/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.qrm;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.base.api.QueryResultMultimap;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.job.StatelessJob;

public abstract class EVMBasedQueryResultMultimap<Match extends IPatternMatch, KeyType, ValueType>
extends QueryResultMultimap<KeyType, ValueType> {
    private final Set<Job<Match>> jobs;
    private final ExecutionSchema schema;

    protected EVMBasedQueryResultMultimap(ExecutionSchema schema) {
        super(Logger.getLogger(EVMBasedQueryResultMultimap.class));
        this.schema = schema;
        this.jobs = new HashSet<Job<Match>>();
        this.jobs.add(new StatelessJob(CRUDActivationStateEnum.CREATED, new IMatchProcessor<Match>(){

            public void process(Match match) {
                Object key = EVMBasedQueryResultMultimap.this.getKeyFromMatch(match);
                Object value = EVMBasedQueryResultMultimap.this.getValueFromMatch(match);
                EVMBasedQueryResultMultimap.this.internalPut(key, value);
            }
        }));
        this.jobs.add(new StatelessJob(CRUDActivationStateEnum.DELETED, new IMatchProcessor<Match>(){

            public void process(Match match) {
                Object key = EVMBasedQueryResultMultimap.this.getKeyFromMatch(match);
                Object value = EVMBasedQueryResultMultimap.this.getValueFromMatch(match);
                EVMBasedQueryResultMultimap.this.internalRemove(key, value);
            }
        }));
    }

    protected EVMBasedQueryResultMultimap(ViatraQueryEngine engine) {
        this(ExecutionSchemas.createViatraQueryExecutionSchema(engine, Schedulers.getQueryEngineSchedulerFactory(engine)));
    }

    public <Matcher extends ViatraQueryMatcher<Match>> void addMatcherToMultimapResults(IQuerySpecification<Matcher> querySpecification) {
        this.schema.addRule(Rules.newMatcherRuleSpecification(querySpecification, Lifecycles.getDefault(false, true), this.jobs));
    }

    protected abstract KeyType getKeyFromMatch(Match var1);

    protected abstract ValueType getValueFromMatch(Match var1);
}

