/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.IQueryResultViewModelListener;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtext.xbase.lib.Conversions;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
class QueryResultTreeContentProvider implements ITreeContentProvider, IQueryResultViewModelListener {
  protected TreeViewer viewer;
  
  protected QueryResultTreeInput input;
  
  protected AdapterFactoryContentProvider adapterFactoryContentProvider;
  
  public QueryResultTreeContentProvider() {
    final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    AdapterFactoryContentProvider _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    this.adapterFactoryContentProvider = _adapterFactoryContentProvider;
  }
  
  @Override
  public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
    Preconditions.checkArgument((viewer instanceof TreeViewer));
    this.viewer = ((TreeViewer) viewer);
    if ((oldInput instanceof QueryResultTreeInput)) {
      ((QueryResultTreeInput)oldInput).removeListener(this);
    }
    if ((newInput instanceof QueryResultTreeInput)) {
      this.input = ((QueryResultTreeInput) newInput);
      ((QueryResultTreeInput)newInput).addListener(this);
    } else {
      if ((newInput != null)) {
        Class<?> _class = newInput.getClass();
        String _name = _class.getName();
        String _format = String.format("Invalid input type %s for List Viewer.", _name);
        throw new IllegalArgumentException(_format);
      }
    }
  }
  
  @Override
  public void dispose() {
    boolean _notEquals = (!Objects.equal(this.input, null));
    if (_notEquals) {
      this.input.removeListener(this);
    }
  }
  
  @Override
  public Object[] getElements(final Object inputElement) {
    return this.getChildren(inputElement);
  }
  
  @Override
  public Object[] getChildren(final Object parentElement) {
    return this.getChildrenInternal(parentElement);
  }
  
  protected Object[] _getChildrenInternal(final QueryResultTreeInput inputElement) {
    Map<String, QueryResultTreeMatcher> _matchers = inputElement.getMatchers();
    return ((Object[])Conversions.unwrapArray(_matchers.values(), Object.class));
  }
  
  protected Object[] _getChildrenInternal(final QueryResultTreeMatcher inputElement) {
    Collection _xblockexpression = null;
    {
      Exception _exception = inputElement.getException();
      boolean _notEquals = (!Objects.equal(_exception, null));
      if (_notEquals) {
        return null;
      }
      ViatraQueryMatcher _matcher = inputElement.getMatcher();
      IPatternMatch _filterMatch = inputElement.getFilterMatch();
      _xblockexpression = _matcher.getAllMatches(_filterMatch);
    }
    return ((Object[])Conversions.unwrapArray(_xblockexpression, Object.class));
  }
  
  protected Object[] _getChildrenInternal(final IPatternMatch inputElement) {
    List<String> _parameterNames = inputElement.parameterNames();
    boolean _isEmpty = _parameterNames.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return inputElement.toArray();
    } else {
      return null;
    }
  }
  
  protected Object[] _getChildrenInternal(final Object inputElement) {
    return null;
  }
  
  @Override
  public Object getParent(final Object element) {
    return this.getParentInternal(element);
  }
  
  protected Object _getParentInternal(final QueryResultTreeInput inputElement) {
    return null;
  }
  
  protected Object _getParentInternal(final QueryResultTreeMatcher inputElement) {
    return inputElement.getParent();
  }
  
  protected Object _getParentInternal(final IPatternMatch inputElement) {
    Map<String, QueryResultTreeMatcher> _matchers = this.input.getMatchers();
    IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> _specification = inputElement.specification();
    String _fullyQualifiedName = _specification.getFullyQualifiedName();
    return _matchers.get(_fullyQualifiedName);
  }
  
  protected Object _getParentInternal(final Object inputElement) {
    return null;
  }
  
  @Override
  public boolean hasChildren(final Object element) {
    return this.hasChildrenInternal(element);
  }
  
  protected boolean _hasChildrenInternal(final QueryResultTreeInput inputElement) {
    Map<String, QueryResultTreeMatcher> _matchers = inputElement.getMatchers();
    boolean _isEmpty = _matchers.isEmpty();
    return (!_isEmpty);
  }
  
  protected boolean _hasChildrenInternal(final QueryResultTreeMatcher inputElement) {
    Exception _exception = inputElement.getException();
    boolean _notEquals = (!Objects.equal(_exception, null));
    if (_notEquals) {
      return false;
    }
    ViatraQueryMatcher _matcher = inputElement.getMatcher();
    IPatternMatch _filterMatch = inputElement.getFilterMatch();
    int _countMatches = _matcher.countMatches(_filterMatch);
    return (_countMatches > 0);
  }
  
  protected boolean _hasChildrenInternal(final IPatternMatch inputElement) {
    List<String> _parameterNames = inputElement.parameterNames();
    boolean _isEmpty = _parameterNames.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return true;
    } else {
      return false;
    }
  }
  
  protected boolean _hasChildrenInternal(final Object inputElement) {
    return false;
  }
  
  @Override
  public void matcherAdded(final QueryResultTreeMatcher matcher) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeInput _parent = matcher.getParent();
          QueryResultTreeContentProvider.this.viewer.add(_parent, matcher);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  @Override
  public void matcherFilterUpdated(final QueryResultTreeMatcher matcher) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeContentProvider.this.viewer.refresh(matcher);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  @Override
  public void matcherRemoved(final QueryResultTreeMatcher matcher) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeContentProvider.this.viewer.remove(matcher);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  @Override
  public void matchAdded(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeContentProvider.this.viewer.add(matcher, match);
          QueryResultTreeContentProvider.this.viewer.update(matcher, null);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  @Override
  public void matchUpdated(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeContentProvider.this.viewer.refresh(match);
          QueryResultTreeContentProvider.this.viewer.update(matcher, null);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  @Override
  public void matchRemoved(final QueryResultTreeMatcher matcher, final IPatternMatch match) {
    Tree _tree = this.viewer.getTree();
    Display _display = _tree.getDisplay();
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        Tree _tree = QueryResultTreeContentProvider.this.viewer.getTree();
        boolean _isDisposed = _tree.isDisposed();
        boolean _not = (!_isDisposed);
        if (_not) {
          QueryResultTreeContentProvider.this.viewer.remove(match);
          QueryResultTreeContentProvider.this.viewer.update(matcher, null);
        }
      }
    };
    _display.asyncExec(_function);
  }
  
  public Object[] getChildrenInternal(final Object inputElement) {
    if (inputElement instanceof IPatternMatch) {
      return _getChildrenInternal((IPatternMatch)inputElement);
    } else if (inputElement instanceof QueryResultTreeInput) {
      return _getChildrenInternal((QueryResultTreeInput)inputElement);
    } else if (inputElement instanceof QueryResultTreeMatcher) {
      return _getChildrenInternal((QueryResultTreeMatcher)inputElement);
    } else if (inputElement != null) {
      return _getChildrenInternal(inputElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(inputElement).toString());
    }
  }
  
  public Object getParentInternal(final Object inputElement) {
    if (inputElement instanceof IPatternMatch) {
      return _getParentInternal((IPatternMatch)inputElement);
    } else if (inputElement instanceof QueryResultTreeInput) {
      return _getParentInternal((QueryResultTreeInput)inputElement);
    } else if (inputElement instanceof QueryResultTreeMatcher) {
      return _getParentInternal((QueryResultTreeMatcher)inputElement);
    } else if (inputElement != null) {
      return _getParentInternal(inputElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(inputElement).toString());
    }
  }
  
  public boolean hasChildrenInternal(final Object inputElement) {
    if (inputElement instanceof IPatternMatch) {
      return _hasChildrenInternal((IPatternMatch)inputElement);
    } else if (inputElement instanceof QueryResultTreeInput) {
      return _hasChildrenInternal((QueryResultTreeInput)inputElement);
    } else if (inputElement instanceof QueryResultTreeMatcher) {
      return _hasChildrenInternal((QueryResultTreeMatcher)inputElement);
    } else if (inputElement != null) {
      return _hasChildrenInternal(inputElement);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(inputElement).toString());
    }
  }
}
