/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 *   Andras Okros - minor changes
 */
package org.eclipse.viatra.query.patternlanguage.emf.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.patternlanguage.emf.jvmmodel.JavadocInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFJvmTypesBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Pattern;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.viatra.query.runtime.api.impl.BaseMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Model Inferrer for Pattern grouping. Infers a Group class for every PatternModel.
 * @noreference
 */
@SuppressWarnings("all")
public class PatternGroupClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Extension
  private JvmTypeReferenceBuilder builder;
  
  public JvmGenericType inferPatternGroupClass(final PatternModel model, final JvmTypeReferenceBuilder builder, final boolean includePrivate) {
    JvmGenericType _xblockexpression = null;
    {
      this.builder = builder;
      String _groupClassName = this.groupClassName(model, includePrivate);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        @Override
        public void apply(final JvmGenericType it) {
          String _groupPackageName = PatternGroupClassInferrer.this.groupPackageName(model, includePrivate);
          it.setPackageName(_groupPackageName);
          it.setFinal(true);
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _typeRef = PatternGroupClassInferrer.this.builder.typeRef(BaseGeneratedPatternGroup.class);
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
          String _fileComment = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.getFileComment(model);
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setFileHeader(it, _fileComment);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toClass(model, _groupClassName, _function);
    }
    return _xblockexpression;
  }
  
  public void initializePatternGroup(final JvmGenericType groupClass, final PatternModel model, final JvmTypeReferenceBuilder builder, final boolean includePrivate) {
    this.builder = builder;
    CharSequence _javadocGroupClass = this._javadocInferrer.javadocGroupClass(model, includePrivate);
    String _string = _javadocGroupClass.toString();
    this._eMFJvmTypesBuilder.setDocumentation(groupClass, _string);
    EList<JvmMember> _members = groupClass.getMembers();
    JvmOperation _inferInstanceMethod = this.inferInstanceMethod(model, groupClass);
    this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _inferInstanceMethod);
    EList<JvmMember> _members_1 = groupClass.getMembers();
    JvmField _inferInstanceField = this.inferInstanceField(model, groupClass);
    this._eMFJvmTypesBuilder.<JvmField>operator_add(_members_1, _inferInstanceField);
    EList<JvmMember> _members_2 = groupClass.getMembers();
    JvmConstructor _inferConstructor = this.inferConstructor(model, groupClass, includePrivate);
    this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_2, _inferConstructor);
    if ((!includePrivate)) {
      EList<Pattern> _patterns = model.getPatterns();
      final Function1<Pattern, Boolean> _function = new Function1<Pattern, Boolean>() {
        @Override
        public Boolean apply(final Pattern it) {
          boolean _and = false;
          boolean _isPublic = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it);
          if (!_isPublic) {
            _and = false;
          } else {
            String _name = it.getName();
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(_name);
            boolean _not = (!_isNullOrEmpty);
            _and = _not;
          }
          return Boolean.valueOf(_and);
        }
      };
      Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(_patterns, _function);
      for (final Pattern pattern : _filter) {
        {
          EList<JvmMember> _members_3 = groupClass.getMembers();
          JvmType _findInferredSpecification = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(pattern);
          JvmOperation _inferSpecificationGetter = this.inferSpecificationGetter(pattern, groupClass, _findInferredSpecification);
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _inferSpecificationGetter);
          EList<JvmMember> _members_4 = groupClass.getMembers();
          JvmType _findInferredClass = this._eMFPatternLanguageJvmModelInferrerUtil.findInferredClass(pattern, BaseMatcher.class);
          JvmOperation _inferMatcherGetter = this.inferMatcherGetter(pattern, groupClass, _findInferredClass);
          this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_4, _inferMatcherGetter);
        }
      }
    }
  }
  
  private String groupClassName(final PatternModel model, final boolean includePrivate) {
    String _modelFileName = this._eMFPatternLanguageJvmModelInferrerUtil.modelFileName(model);
    final String fileName = StringExtensions.toFirstUpper(_modelFileName);
    String _xifexpression = null;
    if (includePrivate) {
      _xifexpression = (fileName + "All");
    } else {
      _xifexpression = fileName;
    }
    return _xifexpression;
  }
  
  private String groupPackageName(final PatternModel model, final boolean includePrivate) {
    final String packageName = model.getPackageName();
    String _xifexpression = null;
    if (includePrivate) {
      _xifexpression = (packageName + ".internal");
    } else {
      _xifexpression = packageName;
    }
    return _xifexpression;
  }
  
  public JvmField inferInstanceField(final PatternModel model, final JvmType groupClass) {
    JvmTypeReference _typeRef = this.builder.typeRef(groupClass);
    final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
      @Override
      public void apply(final JvmField it) {
        it.setVisibility(JvmVisibility.PRIVATE);
        it.setStatic(true);
      }
    };
    return this._eMFJvmTypesBuilder.toField(model, "INSTANCE", _typeRef, _function);
  }
  
  public JvmOperation inferInstanceMethod(final PatternModel model, final JvmType groupClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference exception = this.builder.typeRef(ViatraQueryException.class);
      JvmTypeReference _typeRef = this.builder.typeRef(groupClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          CharSequence _javadocGroupClassInstanceMethod = PatternGroupClassInferrer.this._javadocInferrer.javadocGroupClassInstanceMethod(model);
          String _string = _javadocGroupClassInstanceMethod.toString();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          it.setVisibility(JvmVisibility.PUBLIC);
          it.setStatic(true);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, exception);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("if (INSTANCE == null) {");
              _builder.newLine();
              _builder.append("    ");
              _builder.append("INSTANCE = new ");
              _builder.append(groupClass, "    ");
              _builder.append("();");
              _builder.newLineIfNotEmpty();
              _builder.append("}");
              _builder.newLine();
              _builder.append("return INSTANCE;");
              _builder.newLine();
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, "instance", _typeRef, _function);
    }
    return _xblockexpression;
  }
  
  public JvmConstructor inferConstructor(final PatternModel model, final JvmType groupClass, final boolean includePrivate) {
    JvmConstructor _xblockexpression = null;
    {
      final JvmTypeReference exception = this.builder.typeRef(ViatraQueryException.class);
      final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
        @Override
        public void apply(final JvmConstructor it) {
          it.setVisibility(JvmVisibility.PRIVATE);
          String _groupClassName = PatternGroupClassInferrer.this.groupClassName(model, includePrivate);
          it.setSimpleName(_groupClassName);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, exception);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                EList<Pattern> _patterns = model.getPatterns();
                final Function1<Pattern, Boolean> _function = new Function1<Pattern, Boolean>() {
                  @Override
                  public Boolean apply(final Pattern it) {
                    boolean _or = false;
                    if (includePrivate) {
                      _or = true;
                    } else {
                      boolean _isPublic = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.isPublic(it);
                      _or = _isPublic;
                    }
                    return Boolean.valueOf(_or);
                  }
                };
                Iterable<Pattern> _filter = IterableExtensions.<Pattern>filter(_patterns, _function);
                Iterable<Pattern> _filterNull = IterableExtensions.<Pattern>filterNull(_filter);
                final Function1<Pattern, JvmTypeReference> _function_1 = new Function1<Pattern, JvmTypeReference>() {
                  @Override
                  public JvmTypeReference apply(final Pattern it) {
                    JvmType _findInferredSpecification = PatternGroupClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.findInferredSpecification(it);
                    return PatternGroupClassInferrer.this.builder.typeRef(_findInferredSpecification);
                  }
                };
                Iterable<JvmTypeReference> _map = IterableExtensions.<Pattern, JvmTypeReference>map(_filterNull, _function_1);
                for(final JvmTypeReference matcherRef : _map) {
                  _builder.append("querySpecifications.add(");
                  _builder.append(matcherRef, "");
                  _builder.append(".instance());");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toConstructor(model, _function);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferSpecificationGetter(final Pattern model, final JvmType groupClass, final JvmType specificationClass) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _xifexpression = null;
      boolean _equals = Objects.equal(specificationClass, null);
      if (_equals) {
        _xifexpression = this.builder.typeRef(Object.class);
      } else {
        _xifexpression = this.builder.typeRef(specificationClass);
      }
      final JvmTypeReference classRef = _xifexpression;
      final JvmTypeReference exception = this.builder.typeRef(ViatraQueryException.class);
      String _name = model.getName();
      String _firstUpper = StringExtensions.toFirstUpper(_name);
      String _plus = ("get" + _firstUpper);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, exception);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(classRef, "");
              _builder.append(".instance();");
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, classRef, _function);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferMatcherGetter(final Pattern model, final JvmType groupClass, final JvmType matcherClass) {
    JvmOperation _xblockexpression = null;
    {
      JvmTypeReference _xifexpression = null;
      boolean _equals = Objects.equal(matcherClass, null);
      if (_equals) {
        _xifexpression = this.builder.typeRef(Object.class);
      } else {
        _xifexpression = this.builder.typeRef(matcherClass);
      }
      final JvmTypeReference classRef = _xifexpression;
      final JvmTypeReference exception = this.builder.typeRef(ViatraQueryException.class);
      String _name = model.getName();
      String _firstUpper = StringExtensions.toFirstUpper(_name);
      String _plus = ("get" + _firstUpper);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, exception);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmTypeReference _typeRef = PatternGroupClassInferrer.this.builder.typeRef(ViatraQueryEngine.class);
          JvmFormalParameter _parameter = PatternGroupClassInferrer.this._eMFJvmTypesBuilder.toParameter(model, "engine", _typeRef);
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              _builder.append(classRef, "");
              _builder.append(".on(engine);");
            }
          };
          PatternGroupClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _client);
        }
      };
      _xblockexpression = this._eMFJvmTypesBuilder.toMethod(model, _plus, classRef, _function);
    }
    return _xblockexpression;
  }
}
