/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readonly.TmfXmlReadOnlyModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.xychart.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.w3c.dom.Element;

public class XmlXYViewer
extends TmfCommonXLineChartViewer {
    private static final String SPLIT_STRING = "/";
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    private final ITmfXmlModelFactory fFactory = TmfXmlReadOnlyModelFactory.getInstance();
    private final Map<Integer, SeriesData> fSeriesData = new HashMap<Integer, SeriesData>();
    private final XmlViewInfo fViewInfo;
    private @Nullable ITmfXmlStateAttribute fDisplay;
    private @Nullable ITmfXmlStateAttribute fSeriesName;
    private @Nullable XmlXYEntry fEntry;

    public XmlXYViewer(@Nullable Composite parent, XmlViewInfo viewInfo) {
        super(parent, Messages.XmlXYViewer_DefaultViewerTitle, Messages.XmlXYViewer_DefaultXAxis, Messages.XmlXYViewer_DefaultYAxis);
        this.fViewInfo = viewInfo;
    }

    protected void updateData(long start, long end, int nb, @Nullable IProgressMonitor monitor) {
        ITmfXmlStateAttribute display = this.fDisplay;
        ITmfXmlStateAttribute seriesNameAttrib = this.fSeriesName;
        XmlXYEntry entry = this.fEntry;
        if (this.getTrace() == null || display == null || entry == null) {
            return;
        }
        ITmfStateSystem ss = entry.getStateSystem();
        double[] xvalues = XmlXYViewer.getXAxis((long)start, (long)end, (int)nb);
        this.setXAxis(xvalues);
        boolean complete = false;
        long currentEnd = start;
        while (!complete && currentEnd < end) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            complete = ss.waitUntilBuilt(500L);
            currentEnd = ss.getCurrentEndTime();
            try {
                List<Integer> quarks = entry.getQuarks();
                long traceStart = this.getStartTime();
                long traceEnd = this.getEndTime();
                long offset = this.getTimeOffset();
                for (int quark : quarks) {
                    String seriesName = null;
                    if (seriesNameAttrib == null) {
                        seriesName = ss.getAttributeName(quark);
                    } else {
                        int seriesNameQuark = seriesNameAttrib.getAttributeQuark(quark, null);
                        try {
                            ITmfStateValue seriesNameValue = ss.querySingleState(start, seriesNameQuark).getStateValue();
                            if (!seriesNameValue.isNull()) {
                                seriesName = seriesNameValue.toString();
                            }
                            if (seriesName == null || seriesName.isEmpty()) {
                                seriesName = ss.getAttributeName(quark);
                            }
                        }
                        catch (TimeRangeException e) {
                            seriesName = ss.getAttributeName(quark);
                        }
                    }
                    this.fSeriesData.put(quark, new SeriesData(xvalues.length, display.getAttributeQuark(quark, null), seriesName, entry.getType()));
                }
                int i = 0;
                while (i < xvalues.length) {
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    double x = xvalues[i];
                    long time = (long)x + offset;
                    time = time < traceStart ? traceStart : time;
                    time = time > traceEnd ? traceEnd : time;
                    for (int quark : quarks) {
                        double yvalue = 0.0;
                        SeriesData data = (SeriesData)NonNullUtils.checkNotNull((Object)this.fSeriesData.get(quark));
                        try {
                            ITmfStateValue value = ss.querySingleState(time, data.getDisplayQuark().intValue()).getStateValue();
                            switch (value.getType()) {
                                case DOUBLE: {
                                    yvalue = value.unboxDouble();
                                    break;
                                }
                                case LONG: {
                                    yvalue = value.unboxLong();
                                    break;
                                }
                                case INTEGER: {
                                    yvalue = value.unboxInt();
                                    break;
                                }
                            }
                            data.setYValue(i, yvalue);
                        }
                        catch (TimeRangeException e) {
                            data.setYValue(i, 0.0);
                        }
                    }
                    ++i;
                }
                for (int quark : quarks) {
                    SeriesData data = (SeriesData)NonNullUtils.checkNotNull((Object)this.fSeriesData.get(quark));
                    this.setSeries(data.getSeriesName(), data.getYValues());
                }
                this.updateDisplay();
            }
            catch (StateValueTypeException e) {
                Activator.logError("Error updating the data of XML XY view", e);
            }
            catch (StateSystemDisposedException e) {
                return;
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void initializeDataSource() {
        XmlXYEntry entry;
        super.initializeDataSource();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        Element viewElement = this.fViewInfo.getViewElement("xyView");
        if (viewElement == null) {
            return;
        }
        Set<String> analysisIds = this.fViewInfo.getViewAnalysisIds(viewElement);
        LinkedList<Object> stateSystemModules = new LinkedList<Object>();
        if (!analysisIds.iterator().hasNext()) {
            for (ITmfAnalysisModuleWithStateSystems module : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class)) {
                stateSystemModules.add(module);
            }
        } else {
            for (String moduleId : analysisIds) {
                ITmfAnalysisModuleWithStateSystems module = (ITmfAnalysisModuleWithStateSystems)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, ITmfAnalysisModuleWithStateSystems.class, (String)moduleId);
                if (module == null) continue;
                stateSystemModules.add(module);
            }
        }
        this.fDisplay = null;
        this.fSeriesName = null;
        ITmfStateSystem ss = null;
        this.fEntry = null;
        for (ITmfAnalysisModuleWithStateSystems iTmfAnalysisModuleWithStateSystems : stateSystemModules) {
            ITmfStateSystem ssq;
            IStatus status = iTmfAnalysisModuleWithStateSystems.schedule();
            if (!status.isOK()) {
                return;
            }
            if (!iTmfAnalysisModuleWithStateSystems.waitForInitialization()) {
                return;
            }
            Iterator iterator = iTmfAnalysisModuleWithStateSystems.getStateSystems().iterator();
            if (!iterator.hasNext()) continue;
            ss = ssq = (ITmfStateSystem)iterator.next();
        }
        if (ss == null) {
            return;
        }
        List list = TmfXmlUtils.getChildElements((Element)viewElement, (String)"entry");
        Element entryElement = (Element)list.get(0);
        String path = entryElement.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        this.fEntry = entry = new XmlXYEntry(ss, path, entryElement);
        @NonNull List displayElements = TmfXmlUtils.getChildElements((Element)entryElement, (String)"display");
        if (displayElements.isEmpty()) {
            Activator.logWarning(String.format("XML view: entry for %s should have a display element", path));
            return;
        }
        Element displayElement = (Element)displayElements.get(0);
        this.fDisplay = this.fFactory.createStateAttribute(displayElement, (IXmlStateSystemContainer)entry);
        List seriesNameElements = TmfXmlUtils.getChildElements((Element)entryElement, (String)"name");
        if (!seriesNameElements.isEmpty()) {
            Element seriesNameElement = (Element)seriesNameElements.get(0);
            this.fSeriesName = this.fFactory.createStateAttribute(seriesNameElement, (IXmlStateSystemContainer)entry);
        }
    }

    public void viewInfoUpdated() {
        this.reinitialize();
    }

    private static enum DisplayType {
        ABSOLUTE,
        DELTA;

    }

    private class SeriesData {
        private final double[] fYValues;
        private final double @Nullable [] fYAbsoluteValues;
        private final Integer fDisplayQuark;
        private final String fName;
        private final DisplayType fType;

        public SeriesData(int length, int attributeQuark, String seriesName, DisplayType type) {
            this.fYValues = new double[length];
            this.fDisplayQuark = attributeQuark;
            this.fName = seriesName;
            this.fType = type;
            switch (this.fType) {
                case DELTA: {
                    this.fYAbsoluteValues = new double[length];
                    break;
                }
                default: {
                    this.fYAbsoluteValues = null;
                }
            }
        }

        public double[] getYValues() {
            return this.fYValues;
        }

        public Integer getDisplayQuark() {
            return this.fDisplayQuark;
        }

        public String getSeriesName() {
            return this.fName;
        }

        public void setYValue(int i, double yvalue) {
            switch (this.fType) {
                case DELTA: {
                    double[] absoluteVals = this.fYAbsoluteValues;
                    if (absoluteVals == null) {
                        throw new IllegalStateException();
                    }
                    absoluteVals[i] = yvalue;
                    double prevValue = yvalue;
                    if (i > 0) {
                        prevValue = absoluteVals[i - 1];
                    }
                    this.fYValues[i] = yvalue - prevValue;
                    break;
                }
                default: {
                    this.fYValues[i] = yvalue;
                }
            }
        }
    }

    private static class XmlXYEntry
    implements IXmlStateSystemContainer {
        private final ITmfStateSystem fStateSystem;
        private final String fPath;
        private final DisplayType fType;

        /*
         * Exception decompiling
         */
        public XmlXYEntry(ITmfStateSystem stateSystem, String path, Element entryElement) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl24 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public @Nullable String getAttributeValue(@Nullable String name) {
            return name;
        }

        public ITmfStateSystem getStateSystem() {
            return this.fStateSystem;
        }

        public @NonNull Iterable<@NonNull TmfXmlLocation> getLocations() {
            return Collections.EMPTY_SET;
        }

        public DisplayType getType() {
            return this.fType;
        }

        public List<Integer> getQuarks() {
            String[] paths = this.fPath.split(XmlXYViewer.SPLIT_STRING);
            List<Integer> quarks = Collections.singletonList(-1);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                LinkedList<Integer> subQuarks = new LinkedList<Integer>();
                String name = WILDCARD_PATTERN.matcher(path).replaceAll(".*");
                for (int relativeQuark : quarks) {
                    subQuarks.addAll(this.fStateSystem.getSubAttributes(relativeQuark, false, name));
                }
                quarks = subQuarks;
                ++n2;
            }
            return quarks;
        }
    }
}

