/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building.LttngKernelExecGraphProvider;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class LttngWorker
implements IGraphWorker {
    private final HostThread fHostTid;
    private final long fStart;
    private String fThreadName;
    private LttngKernelExecGraphProvider.ProcessStatus fStatus = LttngKernelExecGraphProvider.ProcessStatus.UNKNOWN;
    private LttngKernelExecGraphProvider.ProcessStatus fOldStatus = LttngKernelExecGraphProvider.ProcessStatus.UNKNOWN;

    public LttngWorker(HostThread ht, String name, long ts) {
        this.fHostTid = ht;
        this.fThreadName = name;
        this.fStart = ts;
    }

    public String getHostId() {
        return this.fHostTid.getHost();
    }

    public @NonNull Map<@NonNull String, @NonNull String> getWorkerInformation(long t) {
        int tid = this.fHostTid.getTid();
        if (tid == -1) {
            return Collections.EMPTY_MAP;
        }
        Optional<@Nullable KernelAnalysisModule> kam = TmfTraceManager.getInstance().getActiveTraceSet().stream().filter(trace -> trace.getHostId().equals(this.getHostId())).map(trace -> (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel")).filter(mod -> mod != null).findFirst();
        if (!kam.isPresent()) {
            return Collections.EMPTY_MAP;
        }
        KernelAnalysisModule module = kam.get();
        HashMap<String, String> info = new HashMap<String, String>();
        int priority = KernelThreadInformationProvider.getThreadPriority((KernelAnalysisModule)module, (int)tid, (long)t);
        if (priority != -1) {
            info.put(NonNullUtils.nullToEmptyString((Object)Messages.LttngWorker_threadPriority), Integer.toString(priority));
        }
        return info;
    }

    public void setName(String name) {
        this.fThreadName = name;
    }

    public String getName() {
        return this.fThreadName;
    }

    public void setStatus(LttngKernelExecGraphProvider.ProcessStatus status) {
        this.fOldStatus = this.fStatus;
        this.fStatus = status;
    }

    public LttngKernelExecGraphProvider.ProcessStatus getStatus() {
        return this.fStatus;
    }

    public LttngKernelExecGraphProvider.ProcessStatus getOldStatus() {
        return this.fOldStatus;
    }

    public HostThread getHostThread() {
        return this.fHostTid;
    }

    public long getStart() {
        return this.fStart;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof LttngWorker) {
            return this.getHostThread().equals((Object)((LttngWorker)obj).getHostThread());
        }
        return false;
    }

    public int hashCode() {
        return this.fHostTid.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + this.fThreadName + ',' + this.fHostTid.getTid() + ']';
    }
}

