/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.datastore.core.historytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.datastore.core.Activator;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;

public class HtIo<E extends IHTInterval, N extends HTNode<E>> {
    private static final Logger LOGGER = TraceCompassLog.getLogger(HtIo.class);
    private static final int CACHE_SIZE = 256;
    private static final LoadingCache<CacheKey, HTNode<IHTInterval>> NODE_CACHE = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().maximumSize(256L).build((CacheLoader)new CacheLoader<CacheKey, HTNode<IHTInterval>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HTNode<IHTInterval> load(CacheKey key) throws IOException {
            HtIo<IHTInterval, HTNode<IHTInterval>> io = key.fHistoryTreeIo;
            int seqNb = key.fSeqNumber;
            LOGGER.finest(() -> "[HtIo:CacheMiss] seqNum=" + seqNb);
            HtIo<IHTInterval, HTNode<IHTInterval>> htIo = io;
            synchronized (htIo) {
                ((HtIo)io).seekFCToNodePos(((HtIo)io).fFileChannelIn, seqNb);
                return HTNode.readNode(((HtIo)io).fBlockSize, ((HtIo)io).fNodeMaxChildren, ((HtIo)io).fFileChannelIn, ((HtIo)io).fObjectReader, ((HtIo)io).fNodeFactory);
            }
        }
    }));
    private final File fStateHistoryFile;
    private final int fBlockSize;
    private final int fNodeMaxChildren;
    private final IHTIntervalReader<E> fObjectReader;
    private final AbstractHistoryTree.IHTNodeFactory<E, N> fNodeFactory;
    private final FileInputStream fFileInputStream;
    private final FileOutputStream fFileOutputStream;
    private final FileChannel fFileChannelIn;
    private final FileChannel fFileChannelOut;

    @VisibleForTesting
    static void clearCache() {
        NODE_CACHE.invalidateAll();
    }

    @VisibleForTesting
    static <E extends IHTInterval, N extends HTNode<E>> boolean isInCache(HtIo<E, N> htio, int seqNum) {
        @Nullable HTNode present = (HTNode)NODE_CACHE.getIfPresent((Object)new CacheKey(htio, seqNum));
        return present != null;
    }

    public HtIo(File stateHistoryFile, int blockSize, int nodeMaxChildren, boolean newFile, IHTIntervalReader<E> intervalReader, AbstractHistoryTree.IHTNodeFactory<E, N> nodeFactory) throws IOException {
        this.fBlockSize = blockSize;
        this.fNodeMaxChildren = nodeMaxChildren;
        this.fObjectReader = intervalReader;
        this.fNodeFactory = nodeFactory;
        this.fStateHistoryFile = stateHistoryFile;
        if (newFile) {
            boolean success1 = true;
            if (this.fStateHistoryFile.exists()) {
                success1 = this.fStateHistoryFile.delete();
            }
            boolean success2 = this.fStateHistoryFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + this.fStateHistoryFile.getName());
            }
            this.fFileInputStream = new FileInputStream(this.fStateHistoryFile);
            this.fFileOutputStream = new FileOutputStream(this.fStateHistoryFile, false);
        } else {
            this.fFileInputStream = new FileInputStream(this.fStateHistoryFile);
            this.fFileOutputStream = new FileOutputStream(this.fStateHistoryFile, true);
        }
        this.fFileChannelIn = this.fFileInputStream.getChannel();
        this.fFileChannelOut = this.fFileOutputStream.getChannel();
    }

    public N readNode(int seqNumber) throws ClosedChannelException {
        LOGGER.finest(() -> "[HtIo:CacheLookup] seqNum=" + seqNumber);
        CacheKey key = new CacheKey(this, seqNumber);
        try {
            return (N)((HTNode)NonNullUtils.checkNotNull((Object)((HTNode)NODE_CACHE.get((Object)key))));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClosedChannelException) {
                throw (ClosedChannelException)cause;
            }
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNode(N node) {
        try {
            int seqNumber = ((HTNode)node).getSequenceNumber();
            CacheKey key = new CacheKey(this, seqNumber);
            NODE_CACHE.put((Object)key, node);
            HtIo htIo = this;
            synchronized (htIo) {
                this.seekFCToNodePos(this.fFileChannelOut, seqNumber);
                ((HTNode)node).writeSelf(this.fFileChannelOut);
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    public FileOutputStream getFileWriter(int nodeOffset) {
        try {
            if (nodeOffset < 0) {
                this.fFileChannelOut.position(0L);
            } else {
                this.seekFCToNodePos(this.fFileChannelOut, nodeOffset);
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return this.fFileOutputStream;
    }

    public FileInputStream supplyATReader(int nodeOffset) {
        try {
            this.seekFCToNodePos(this.fFileChannelIn, nodeOffset);
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return this.fFileInputStream;
    }

    public synchronized void closeFile() {
        try {
            this.fFileInputStream.close();
            this.fFileOutputStream.close();
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void deleteFile() {
        this.closeFile();
        if (!this.fStateHistoryFile.delete()) {
            Activator.getInstance().logError("Failed to delete" + this.fStateHistoryFile.getName());
        }
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.fBlockSize);
    }

    private static final class CacheKey {
        public final HtIo<IHTInterval, HTNode<IHTInterval>> fHistoryTreeIo;
        public final int fSeqNumber;

        public CacheKey(HtIo<IHTInterval, HTNode<IHTInterval>> htio, int seqNumber) {
            this.fHistoryTreeIo = htio;
            this.fSeqNumber = seqNumber;
        }

        public int hashCode() {
            return Objects.hash(this.fHistoryTreeIo, this.fSeqNumber);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.fHistoryTreeIo.equals(other.fHistoryTreeIo) && this.fSeqNumber == other.fSeqNumber;
        }
    }
}

