/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisReport;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewFactory;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysisReport;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfReportElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenReportHandler
extends AbstractHandler {
    public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        List elements = ((IStructuredSelection)selection).toList();
        List reportElements = elements.stream().filter(elem -> elem instanceof TmfReportElement).map(elem -> (TmfReportElement)elem).collect(Collectors.toList());
        for (TmfReportElement reportElem : reportElements) {
            IOnDemandAnalysisReport report = reportElem.getReport();
            if (!(report instanceof LamiAnalysisReport)) continue;
            LamiAnalysisReport lamiReport = (LamiAnalysisReport)report;
            Display.getDefault().syncExec(() -> {
                try {
                    LamiReportViewFactory.createNewView(lamiReport);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            });
        }
        return null;
    }
}

