/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.operation.BaseFetchOperation;
import org.eclipse.team.svn.revision.graph.operation.LogEntriesCallback;

public class FetchNewRevisionsOperation
extends BaseFetchOperation {
    protected long lastRepositoryRevision;

    public FetchNewRevisionsOperation(IRepositoryResource resource, RepositoryCache repositoryCache, long lastRepositoryRevision, boolean isSkipFetchErrors) {
        super("Operation_FetchNewRevisions", resource, repositoryCache, isSkipFetchErrors);
        this.lastRepositoryRevision = lastRepositoryRevision;
    }

    protected void prepareData(IProgressMonitor monitor) throws Exception {
        RepositoryCacheInfo cacheInfo = this.repositoryCache.getCacheInfo();
        long startRevision = cacheInfo.getLastProcessedRevision() + 1L;
        long endRevision = this.lastRepositoryRevision;
        boolean bl = this.canRun = this.lastRepositoryRevision > cacheInfo.getLastProcessedRevision();
        if (this.canRun) {
            this.logOptions = 262144L;
            this.revProps = ISVNConnector.DEFAULT_LOG_ENTRY_PROPS;
            this.logEntryCallback = new LogEntriesCallback((IActionOperation)this, monitor, (int)(endRevision - startRevision + 1L), this.repositoryCache);
            cacheInfo.setSkippedRevisions(startRevision, endRevision);
            cacheInfo.setLastProcessedRevision(endRevision);
            cacheInfo.save();
            this.repositoryCache.expandRevisionsCount(endRevision);
        }
    }

    protected long getStartSkippedRevision() {
        return this.repositoryCache.getCacheInfo().getStartSkippedRevision();
    }

    protected long getEndSkippedRevision() {
        return this.repositoryCache.getCacheInfo().getEndSkippedRevision();
    }
}

