/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.IRevisionLinkProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.IDialogPanel;
import org.eclipse.team.svn.ui.panel.common.InputRevisionPanel;
import org.eclipse.ui.IWorkbenchPart;

public class AddRevisionLinksAction
extends BaseRevisionGraphAction {
    public static final String AddRevisionLinksAction_ID = "AddRevisionLinks";

    public AddRevisionLinksAction(IWorkbenchPart part) {
        super(part);
        this.setText(SVNUIMessages.AddRevisionLinkAction_label);
        this.setId(AddRevisionLinksAction_ID);
        this.setToolTipText(SVNUIMessages.AddRevisionLinkAction_label);
    }

    protected boolean calculateEnabled() {
        return this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER).length > 0;
    }

    public void run() {
        InputRevisionPanel panel = new InputRevisionPanel(null, false, null);
        DefaultDialog dlg = new DefaultDialog(this.getWorkbenchPart().getSite().getShell(), (IDialogPanel)panel);
        if (dlg.open() == 0) {
            RevisionEditPart[] editParts = this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER);
            final IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(editParts);
            CompositeOperation op = new CompositeOperation("Operation_HAddSelectedRevision", SVNUIMessages.class);
            final String comment = panel.getRevisionComment();
            AddRevisionLinkOperation addLinksOp = new AddRevisionLinkOperation(new IRevisionLinkProvider(){

                public IRevisionLink[] getRevisionLinks() {
                    IRevisionLink[] links = new IRevisionLink[resources.length];
                    int i = 0;
                    while (i < resources.length) {
                        links[i] = SVNUtility.createRevisionLink((IRepositoryResource)resources[i]);
                        links[i].setComment(comment);
                        ++i;
                    }
                    return links;
                }
            }, null);
            op.add((IActionOperation)addLinksOp);
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            IRepositoryLocation location = this.getRepositoryLocation(editParts[0]);
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{location}, true));
            this.runOperation((IActionOperation)op);
        }
    }
}

