/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.GenericStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStorage
extends GenericStorage<String> {
    public StringStorage() {
        this.addSimple("");
    }

    public StringStorage(byte[] bytes) {
        this.fromBytes(bytes);
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(bytes));
            int stringsCount = bytesIn.readInt();
            int i = 0;
            while (i < stringsCount) {
                byte[] strBytes = BytesUtility.readBytesWithLength(bytesIn);
                String str = BytesUtility.getString(strBytes);
                this.dataList.add(str);
                this.hash.put(str, this.dataList.size() - 1);
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream bytes = new DataOutputStream(byteArray);
            bytes.writeInt(this.dataList.size());
            for (String str : this.dataList) {
                byte[] strBytes = BytesUtility.convertStringToBytes(str);
                BytesUtility.writeBytesWithLength(bytes, strBytes);
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

