/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.mylyn;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.mylyn.SVNLinkedTaskInfo;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.properties.bugtraq.IssueList;
import org.eclipse.team.svn.ui.properties.bugtraq.LinkList;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

public class SVNLinkedTaskInfoAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTED_TYPES = new Class[]{AbstractTaskReference.class};

    public Class[] getAdapterList() {
        return ADAPTED_TYPES;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!AbstractTaskReference.class.equals((Object)adapterType)) {
            return null;
        }
        if (adaptableObject instanceof ChangeSet) {
            return this.createFromChangeSet((ChangeSet)adaptableObject);
        }
        Object adapted = Platform.getAdapterManager().getAdapter(adaptableObject, SVNLogEntry.class);
        if (adapted != null) {
            IHistoryPage historyPage;
            IViewPart view;
            SVNLogEntry historyEntry = (SVNLogEntry)adapted;
            String comment = historyEntry.message == null ? "" : historyEntry.message;
            IWorkbenchPage page = UIMonitorUtility.getActivePage();
            if (page != null && (view = page.findView("org.eclipse.team.ui.GenericHistoryView")) instanceof IHistoryView && (historyPage = ((IHistoryView)view).getHistoryPage()) instanceof SVNHistoryPage) {
                IResource resource = ((SVNHistoryPage)historyPage).getResource();
                return new SVNLinkedTaskInfo(this.getTaskRepositoryUrl(resource), null, this.getTaskFullUrl(resource, comment), comment);
            }
            return new SVNLinkedTaskInfo(null, null, null, comment);
        }
        return null;
    }

    protected AbstractTaskReference createFromChangeSet(ChangeSet set) {
        IResource[] resources = set.getResources();
        if (resources != null && resources.length > 0) {
            return new SVNLinkedTaskInfo(this.getTaskRepositoryUrl(resources[0]), null, this.getTaskFullUrl(resources[0], set.getComment()), set.getComment());
        }
        return new SVNLinkedTaskInfo(null, null, null, set.getComment());
    }

    protected String getTaskRepositoryUrl(IResource resource) {
        TaskRepository repository;
        if (resource != null && (repository = TasksUiPlugin.getDefault().getRepositoryForResource(resource)) != null) {
            return repository.getRepositoryUrl();
        }
        return null;
    }

    protected String getTaskFullUrl(IResource resource, String comment) {
        BugtraqModel model = SVNLinkedTaskInfoAdapterFactory.getBugtraqModel(resource);
        IssueList linkList = new IssueList();
        linkList.parseMessage(comment, model);
        List issues = linkList.getLinks();
        if (issues.size() > 0) {
            return model.getResultingURL((LinkList.LinkPlacement)issues.get(0));
        }
        return null;
    }

    public static BugtraqModel getBugtraqModel(IResource resource) {
        CommitPanel.CollectPropertiesOperation bugtraqOp = new CommitPanel.CollectPropertiesOperation(new IResource[]{resource});
        bugtraqOp.run((IProgressMonitor)new NullProgressMonitor());
        return bugtraqOp.getBugtraqModel();
    }
}

