/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.forms.blocks;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.forms.parts.AbstractTreeSection;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatable;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;

public abstract class AbstractMasterDetailsBlock
extends MasterDetailsBlock
implements IDisposable,
IAdaptable,
IValidatable {
    private String message = null;
    private int type = -1;
    protected AbstractTreeSection treeSection;
    protected Color parentBackground = null;

    public void dispose() {
        if (this.treeSection != null) {
            this.treeSection.dispose();
            this.treeSection = null;
        }
    }

    public void createContent(IManagedForm managedForm, Composite parent) {
        this.parentBackground = parent.getBackground();
        super.createContent(managedForm, parent);
        parent.setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 1));
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)parent);
        if (!parent.getBackground().equals((Object)this.parentBackground)) {
            parent.setBackground(this.parentBackground);
        }
        Composite container = managedForm.getToolkit().createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createMasterGridLayout(false, 1));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.doSetupTreeSectionPart(managedForm, container);
    }

    protected void doSetupTreeSectionPart(IManagedForm managedForm, Composite parent) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)parent);
        this.treeSection = this.doCreateTreeSection(managedForm, parent);
        Assert.isNotNull((Object)((Object)this.treeSection));
        this.treeSection.getSection().setLayoutData((Object)new GridData(4, 4, true, true));
        managedForm.addPart((IFormPart)this.treeSection);
    }

    protected abstract AbstractTreeSection doCreateTreeSection(IManagedForm var1, Composite var2);

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public void setActive(boolean active) {
        if (this.treeSection != null) {
            this.treeSection.setActive(active);
            if (this.detailsPart.getCurrentPage() != null) {
                this.detailsPart.getCurrentPage().selectionChanged((IFormPart)this.treeSection, this.treeSection.getViewer().getSelection());
            }
        }
    }

    public boolean isValid() {
        IDetailsPage detailsPage;
        boolean valid = true;
        if (this.treeSection != null) {
            valid &= this.treeSection.isValid();
            this.setMessage(this.treeSection.getMessage(), this.treeSection.getMessageType());
        }
        IDetailsPage iDetailsPage = detailsPage = this.detailsPart != null ? this.detailsPart.getCurrentPage() : null;
        if (detailsPage instanceof IValidatable) {
            IValidatable detailsSection = (IValidatable)detailsPage;
            valid &= detailsSection.isValid();
            if (this.getMessageType() < detailsSection.getMessageType()) {
                this.setMessage(detailsSection.getMessage(), detailsSection.getMessageType());
            }
        }
        return valid;
    }

    protected void setMessage(String message, int type) {
        this.message = message;
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.type;
    }
}

