/*******************************************************************************
 * Copyright (c) 2000, 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.cocoa;

public class NSTextContainer extends NSObject {

public NSTextContainer() {
	super();
}

public NSTextContainer(long /*int*/ id) {
	super(id);
}

public NSTextContainer(id id) {
	super(id);
}

public NSSize containerSize() {
	NSSize result = new NSSize();
	OS.objc_msgSend_stret(result, this.id, OS.sel_containerSize);
	return result;
}

public NSTextContainer initWithContainerSize(NSSize size) {
	long /*int*/ result = OS.objc_msgSend(this.id, OS.sel_initWithContainerSize_, size);
	return result == this.id ? this : (result != 0 ? new NSTextContainer(result) : null);
}

public void setContainerSize(NSSize containerSize) {
	OS.objc_msgSend(this.id, OS.sel_setContainerSize_, containerSize);
}

public void setLineFragmentPadding(double /*float*/ lineFragmentPadding) {
	OS.objc_msgSend(this.id, OS.sel_setLineFragmentPadding_, lineFragmentPadding);
}

public void setWidthTracksTextView(boolean widthTracksTextView) {
	OS.objc_msgSend(this.id, OS.sel_setWidthTracksTextView_, widthTracksTextView);
}

}
