/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public abstract class AbstractProjectLoadOperation
extends AbstractLoadOperation {
    private Collection<IProject> projects;
    private boolean includeReferencedProjects;

    public AbstractProjectLoadOperation(String label, Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        super(label, mmDescriptor);
        this.includeReferencedProjects = includeReferencedProjects;
        this.addProjects(projects);
    }

    public ISchedulingRule getRule() {
        return this.getSchedulingRuleFactory().createLoadSchedulingRule(this.getProjects(), this.isIncludeReferencedProjects());
    }

    public Collection<IProject> getProjects() {
        return this.projects;
    }

    public boolean isIncludeReferencedProjects() {
        return this.includeReferencedProjects;
    }

    @Override
    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        int mmDescriptorsComparison;
        int projectsComparison;
        HashSet<IProject> projectGroup = new HashSet<IProject>(projects);
        if (includeReferencedProjects) {
            for (IProject p : projects) {
                projectGroup.addAll(ExtendedPlatform.getProjectGroup((IProject)p, (boolean)false));
            }
        }
        return !((projectsComparison = this.compare(this.getProjects(), projectGroup)) != EQUAL && projectsComparison != GREATER_THAN || (mmDescriptorsComparison = this.compare(this.getMetaModelDescriptor(), mmDescriptor)) != EQUAL && mmDescriptorsComparison != GREATER_THAN);
    }

    @Override
    public boolean covers(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IFile file : files) {
            projects.add(file.getProject());
        }
        return this.covers(projects, false, null);
    }

    public void addProjects(Collection<IProject> projects) {
        if (this.getProjects() == null) {
            this.projects = new HashSet<IProject>();
        }
        this.getProjects().addAll(projects);
        if (this.includeReferencedProjects) {
            for (IProject p : projects) {
                this.getProjects().addAll(this.getProjectGroup(p, false));
            }
        }
    }
}

