/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.workspace.internal.loading.ModelLoadJob;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.FileUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ModelLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ModelUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ProjectReloadOperation;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;

public class LoadJobScheduler {
    public void scheduleModelLoadJob(AbstractLoadOperation operation) {
        if (operation instanceof FileLoadOperation) {
            this.scheduleModelLoadJob((FileLoadOperation)operation);
        } else if (operation instanceof ProjectLoadOperation) {
            this.scheduleModelLoadJob((ProjectLoadOperation)operation);
        } else if (operation instanceof ModelLoadOperation) {
            this.scheduleModelLoadJob((ModelLoadOperation)operation);
        } else if (operation instanceof FileReloadOperation) {
            this.scheduleModelLoadJob((FileReloadOperation)operation);
        } else if (operation instanceof ProjectReloadOperation) {
            this.scheduleModelLoadJob((ProjectReloadOperation)operation);
        } else if (operation instanceof FileUnloadOperation) {
            this.scheduleModelLoadJob((FileUnloadOperation)operation);
        } else if (operation instanceof ModelUnloadOperation) {
            this.scheduleModelLoadJob((ModelUnloadOperation)operation);
        } else {
            throw new UnsupportedOperationException(NLS.bind((String)Messages.error_unsupportedLoadOperation, (Object)((Object)((Object)operation)).getClass().getSimpleName()));
        }
    }

    protected void scheduleModelLoadJob(FileLoadOperation fileLoadOperation) {
        if (this.coveredByExistingLoadJob(fileLoadOperation)) {
            return;
        }
        if (!this.addToExistingLoadJob(fileLoadOperation)) {
            Job job = this.createModelLoadJob(fileLoadOperation);
            job.setPriority(40);
            job.setRule(fileLoadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(ProjectLoadOperation prjLoadOperation) {
        if (this.coveredByExistingLoadJob(prjLoadOperation)) {
            return;
        }
        if (!this.addToExistingLoadJob(prjLoadOperation)) {
            Job job = this.createModelLoadJob(prjLoadOperation);
            job.setPriority(40);
            job.setRule(prjLoadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(ModelLoadOperation modelLoadOperation) {
        if (this.coveredByExistingLoadJob(modelLoadOperation)) {
            return;
        }
        Job job = this.createModelLoadJob(modelLoadOperation);
        job.setPriority(40);
        job.setRule(modelLoadOperation.getRule());
        job.schedule();
    }

    protected void scheduleModelLoadJob(FileReloadOperation fileReloadOperation) {
        if (this.coveredByExistingReloadJob(fileReloadOperation)) {
            return;
        }
        if (!this.addToExistingReLoadJob(fileReloadOperation)) {
            Job job = this.createModelLoadJob(fileReloadOperation);
            job.setPriority(40);
            job.setRule(fileReloadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(ProjectReloadOperation projectReloadOperation) {
        if (this.coveredByExistingReloadJob(projectReloadOperation)) {
            return;
        }
        if (!this.addToExistingReLoadJob(projectReloadOperation)) {
            Job job = this.createModelLoadJob(projectReloadOperation);
            job.setPriority(40);
            job.setRule(projectReloadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(FileUnloadOperation fileUnloadOperation) {
        Job job = this.createModelLoadJob(fileUnloadOperation);
        job.setPriority(40);
        job.setRule(fileUnloadOperation.getRule());
        job.schedule();
    }

    protected void scheduleModelLoadJob(ModelUnloadOperation modelUnloadOperation) {
        Job job = this.createModelLoadJob(modelUnloadOperation);
        job.setPriority(40);
        job.setRule(modelUnloadOperation.getRule());
        job.schedule();
    }

    public boolean coveredByExistingLoadJob(FileLoadOperation fileLoadOperation) {
        if (fileLoadOperation != null) {
            Collection<IFile> files = fileLoadOperation.getFiles();
            IMetaModelDescriptor metaModelDescriptor = fileLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && ((operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof FileLoadOperation || operation instanceof ProjectLoadOperation) && loadJob.covers(files, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingLoadJob(ProjectLoadOperation prjLoadOperation) {
        if (prjLoadOperation != null) {
            Collection<IProject> projects = prjLoadOperation.getProjects();
            boolean includeReferencedProjects = prjLoadOperation.isIncludeReferencedProjects();
            IMetaModelDescriptor metaModelDescriptor = prjLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof ProjectLoadOperation && loadJob.covers(projects, includeReferencedProjects, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingLoadJob(ModelLoadOperation modelLoadOperation) {
        if (modelLoadOperation != null) {
            IModelDescriptor modelDescriptor = modelLoadOperation.getModelDescriptor();
            boolean includeReferencedProjects = modelLoadOperation.isIncludeReferencedScopes();
            Collection persistedFiles = modelDescriptor.getPersistedFiles(includeReferencedProjects);
            IMetaModelDescriptor metaModelDescriptor = modelLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof ModelLoadOperation && loadJob.covers(persistedFiles, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingReloadJob(FileReloadOperation fileReloadOperation) {
        if (fileReloadOperation != null) {
            Collection<IFile> files = fileReloadOperation.getFiles();
            IMetaModelDescriptor metaModelDescriptor = fileReloadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && ((operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof FileReloadOperation || operation instanceof ProjectReloadOperation) && loadJob.covers(files, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingReloadJob(ProjectReloadOperation projectReloadOperation) {
        if (projectReloadOperation != null) {
            Collection<IProject> projects = projectReloadOperation.getProjects();
            boolean includeReferencedProjects = projectReloadOperation.isIncludeReferencedProjects();
            IMetaModelDescriptor metaModelDescriptor = projectReloadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof ProjectReloadOperation && loadJob.covers(projects, includeReferencedProjects, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean addToExistingLoadJob(FileLoadOperation fileLoadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof FileLoadOperation) {
                ((FileLoadOperation)((Object)operation)).addFiles(fileLoadOperation.getFiles());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingLoadJob(ProjectLoadOperation prjLoadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof ProjectLoadOperation) {
                ((ProjectLoadOperation)((Object)operation)).addProjects(prjLoadOperation.getProjects());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingReLoadJob(FileReloadOperation fileReloadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && (operation = ((ModelLoadJob)job).getOperation()) instanceof FileReloadOperation && job.getState() != 4) {
                ((FileReloadOperation)((Object)operation)).addFiles(fileReloadOperation.getFiles());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingReLoadJob(ProjectReloadOperation projectReloadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof ProjectReloadOperation) {
                ((ProjectReloadOperation)((Object)operation)).addProjects(projectReloadOperation.getProjects());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private <T extends AbstractLoadOperation> Job createModelLoadJob(T operation) {
        return new ModelLoadJob<T>(operation);
    }
}

