/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.ui.business.internal.session.factory.UISessionFactoryDescriptor;

public final class UISessionFactoryDescriptorRegistry {
    private static final List<UISessionFactoryDescriptor> EXTENSIONS = new ArrayList<UISessionFactoryDescriptor>();
    private static final Map<String, UISessionFactoryDescriptor> ID_TO_DESCRITPOR_MAP = new HashMap<String, UISessionFactoryDescriptor>();

    private UISessionFactoryDescriptorRegistry() {
    }

    public static void addExtension(UISessionFactoryDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRITPOR_MAP.put(extension.getId(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRITPOR_MAP.clear();
    }

    public static List<UISessionFactoryDescriptor> getRegisteredExtensions() {
        return new ArrayList<UISessionFactoryDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (UISessionFactoryDescriptor extension : UISessionFactoryDescriptorRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRITPOR_MAP.remove(extension.getId());
        }
    }

    public static UISessionFactoryDescriptor getDescriptorFromId(String id) {
        return ID_TO_DESCRITPOR_MAP.get(id);
    }
}

