/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.resourcelistener.ISessionFileLoadingListener;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.BundleContext;

public class SessionEditorPlugin
extends EMFPlugin {
    public static final String ID = "org.eclipse.sirius.ui.editor";
    public static final SessionEditorPlugin INSTANCE = new SessionEditorPlugin();
    private static Implementation plugin;

    public SessionEditorPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private ISessionFileLoadingListener modelingProjectExpansionListener;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.modelingProjectExpansionListener = new ISessionFileLoadingListener(){

                public void notifySessionLoadedFromModelingProjectExpansion(Session session) {
                    URI uri = session.getSessionResource().getURI();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))), "org.eclipse.sirius.ui.editor.session");
                        }
                        catch (PartInitException e) {
                            this.error("An error occurred while opening the session's editor.", (Exception)((Object)e));
                        }
                    });
                }
            };
            SiriusEditPlugin.getPlugin().addSessionFileLoadingListener(this.modelingProjectExpansionListener);
        }

        public void stop(BundleContext context) throws Exception {
            SiriusEditPlugin.getPlugin().removeSessionFileLoadingListener(this.modelingProjectExpansionListener);
            this.modelingProjectExpansionListener = null;
            super.stop(context);
        }

        public void error(String message, Exception e) {
            String msgToDisplay = message;
            if (message == null && e != null) {
                msgToDisplay = e.getMessage();
            }
            if (e instanceof CoreException) {
                this.getLog().log(((CoreException)e).getStatus());
            } else {
                Status status = new Status(4, this.getBundle().getSymbolicName(), msgToDisplay, (Throwable)e);
                this.getLog().log((IStatus)status);
            }
        }
    }
}

