/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.sirius.diagram.description.CenteringStyle;

public final class RectilinearEdgeUtil {
    private static final int MINIMAL_SEGMENT_SIZE = 20;

    private RectilinearEdgeUtil() {
    }

    public static void centerEdgeEnds(PointList line, Point srcRefPoint, Point tgtRefPoint, CenteringStyle centeringStyle) {
        if (CenteringStyle.BOTH == centeringStyle || CenteringStyle.SOURCE == centeringStyle) {
            RectilinearEdgeUtil.addPointsIfNeeded(line, srcRefPoint, true);
            RectilinearEdgeUtil.alignSegmentTowardAnchor(line, srcRefPoint, true);
        }
        if (CenteringStyle.BOTH == centeringStyle || CenteringStyle.TARGET == centeringStyle) {
            RectilinearEdgeUtil.addPointsIfNeeded(line, tgtRefPoint, false);
            RectilinearEdgeUtil.alignSegmentTowardAnchor(line, tgtRefPoint, false);
        }
        RectilinearEdgeUtil.removeRedundantPoints(line);
    }

    private static void addPointsIfNeeded(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        if (line.size() == 2) {
            RectilinearEdgeUtil.addPointForStraightEdge(line);
        } else if (line.size() == 3 && RectilinearEdgeUtil.isOppositeEndWillBeAffected(line, absoluteAnchorCoordinates, isFirst)) {
            RectilinearEdgeUtil.addPointForLEdge(line, isFirst);
        }
    }

    private static void addPointForStraightEdge(PointList line) {
        int segmentOrientation;
        Point pointToInsert = null;
        int n = segmentOrientation = line.getFirstPoint().x == line.getLastPoint().x ? 128 : 64;
        if (segmentOrientation == 128) {
            int xValue = line.getFirstPoint().x;
            int delta = (line.getFirstPoint().y - line.getLastPoint().y) / 2;
            pointToInsert = new Point(xValue, line.getFirstPoint().y - delta);
        } else {
            int yValue = line.getFirstPoint().y;
            int delta = (line.getFirstPoint().x - line.getLastPoint().x) / 2;
            pointToInsert = new Point(line.getFirstPoint().x - delta, yValue);
        }
        line.insertPoint(pointToInsert, 1);
        line.insertPoint(pointToInsert.getCopy(), 1);
    }

    private static boolean isOppositeEndWillBeAffected(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        LineSeg oppositeSegment = RectilinearEdgeUtil.getSegment(line, !isFirst);
        int origTermDelta = 0;
        int origNewLocDelta = 0;
        if (oppositeSegment.isVertical()) {
            origTermDelta = oppositeSegment.getOrigin().y - oppositeSegment.getTerminus().y;
            origNewLocDelta = oppositeSegment.getOrigin().y - absoluteAnchorCoordinates.y;
        } else {
            origTermDelta = oppositeSegment.getOrigin().x - oppositeSegment.getTerminus().x;
            origNewLocDelta = oppositeSegment.getOrigin().x - absoluteAnchorCoordinates.x;
        }
        return origTermDelta > 0 ^ origNewLocDelta > 0;
    }

    private static void addPointForLEdge(PointList line, boolean isFirst) {
        LineSeg segment = RectilinearEdgeUtil.getSegment(line, isFirst);
        Point origin = segment.getOrigin();
        Point terminus = segment.getTerminus();
        Point newPoint = origin.getCopy();
        if (segment.isHorizontal()) {
            int newPointX = origin.x > terminus.x ? origin.x - 20 : origin.x + 20;
            newPoint.setX(newPointX);
        } else {
            int newPointY = origin.y > terminus.y ? origin.y - 20 : origin.y + 20;
            newPoint.setY(newPointY);
        }
        if (isFirst) {
            line.insertPoint(newPoint, 1);
            line.insertPoint(newPoint.getCopy(), 1);
        } else {
            line.insertPoint(newPoint, line.size() - 1);
            line.insertPoint(newPoint.getCopy(), line.size() - 1);
        }
    }

    private static void alignSegmentTowardAnchor(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        LineSeg segment = RectilinearEdgeUtil.getSegment(line, isFirst);
        Point origin = segment.getOrigin();
        Point terminus = segment.getTerminus();
        if (segment.isVertical()) {
            origin.setX(absoluteAnchorCoordinates.x());
            terminus.setX(absoluteAnchorCoordinates.x());
        } else {
            origin.setY(absoluteAnchorCoordinates.y());
            terminus.setY(absoluteAnchorCoordinates.y());
        }
        if (isFirst) {
            line.setPoint(origin, 0);
            line.setPoint(terminus, 1);
        } else {
            line.setPoint(origin, line.size() - 1);
            line.setPoint(terminus, line.size() - 2);
        }
    }

    private static LineSeg getSegment(PointList line, boolean isFirst) {
        if (isFirst) {
            return new LineSeg(line.getFirstPoint(), line.getPoint(1));
        }
        return new LineSeg(line.getLastPoint(), line.getPoint(line.size() - 2));
    }

    private static boolean removeRedundantPoints(PointList line) {
        int initialNumberOfPoints = line.size();
        if (line.size() > 2) {
            PointList newLine = new PointList(line.size());
            newLine.addPoint(line.removePoint(0));
            while (line.size() >= 2) {
                Point p0 = newLine.getLastPoint();
                Point p1 = line.getPoint(0);
                Point p2 = line.getPoint(1);
                if (p0.x == p1.x && p0.x == p2.x) {
                    line.removePoint(0);
                    continue;
                }
                if (p0.y == p1.y && p0.y == p2.y) {
                    line.removePoint(0);
                    continue;
                }
                newLine.addPoint(line.removePoint(0));
            }
            while (line.size() > 0) {
                newLine.addPoint(line.removePoint(0));
            }
            line.removeAllPoints();
            line.addAll(newLine);
        }
        return line.size() != initialNumberOfPoints;
    }
}

