/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.layout.provider;

import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;

public abstract class AbstractLayoutProvider
extends AbstractLayoutEditPartProvider {
    public static final String GENERIC_MODELER_CAT = Messages.AbstractLayoutProvider_arrangeAllProfilerTaskCategory;
    public static final ProfilerTask ARRANGE_ALL = new ProfilerTask(GENERIC_MODELER_CAT, Messages.AbstractLayoutProvider_arrangeAllProfilerTaskName);
    protected Map<View, List<Request>> viewsToChangeBoundsRequest = new HashMap<View, List<Request>>();

    public void setViewsToChangeBoundsRequest(Map<View, List<Request>> viewsToChangeBoundsRequest) {
        this.viewsToChangeBoundsRequest = viewsToChangeBoundsRequest;
    }

    public Map<View, List<Request>> getViewsToChangeBoundsRequest() {
        return this.viewsToChangeBoundsRequest;
    }

    public final Command layoutEditParts(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        DiagramEditPart diagramEditPart;
        LayoutProvider diagramLayoutProvider;
        DslCommonPlugin.PROFILER.startWork(ARRANGE_ALL);
        this.getViewsToChangeBoundsRequest().clear();
        if (containerEditPart instanceof DiagramEditPart && (diagramLayoutProvider = this.getDiagramLayoutProvider(diagramEditPart = (DiagramEditPart)containerEditPart, layoutHint)) != null) {
            Command command = this.getCommandFromDiagramLayoutProvider(diagramLayoutProvider, diagramEditPart, layoutHint);
            command.setLabel(Messages.AbstractLayoutProvider_arrangeAllCommandLabel);
            DslCommonPlugin.PROFILER.stopWork(ARRANGE_ALL);
            return command;
        }
        Command command = this.buildCommand(containerEditPart, layoutHint);
        command.setLabel(Messages.AbstractLayoutProvider_arrangeAllCommandLabel);
        this.getViewsToChangeBoundsRequest().clear();
        AbstractLayoutProvider.resetWrappedCommand(command);
        DslCommonPlugin.PROFILER.stopWork(ARRANGE_ALL);
        return command;
    }

    private LayoutProvider getDiagramLayoutProvider(DiagramEditPart diagramEditPart, IAdaptable layoutHint) {
        LayoutProvider candidate = LayoutService.getProvider((IGraphicalEditPart)diagramEditPart);
        if (candidate != null && candidate.isDiagramLayoutProvider()) {
            return candidate;
        }
        return null;
    }

    private Command getCommandFromDiagramLayoutProvider(LayoutProvider diagramLayoutProvider, DiagramEditPart diagramEditPart, IAdaptable layoutHint) {
        Command command = null;
        AbstractLayoutEditPartProvider layoutProvider = diagramLayoutProvider.getLayoutNodeProvider((IGraphicalEditPart)diagramEditPart);
        try {
            Method method = layoutProvider.getClass().getMethod("layoutEditParts", GraphicalEditPart.class, IAdaptable.class);
            Assert.isNotNull((Object)method);
            if (method.getDeclaringClass() != AbstractLayoutProvider.class) {
                command = layoutProvider.layoutEditParts((GraphicalEditPart)diagramEditPart, layoutHint);
            }
        }
        catch (SecurityException e) {
            SiriusTransPlugin.getPlugin().error(Messages.AbstractLayoutProvider_layoutError, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            SiriusTransPlugin.getPlugin().error(Messages.AbstractLayoutProvider_layoutError, (Throwable)e);
        }
        if (command == null) {
            List children = diagramEditPart.getChildren();
            command = layoutProvider.layoutEditParts(children, layoutHint);
        }
        return command;
    }

    private Command buildCommand(GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        CompoundCommand cc = new CompoundCommand();
        for (IGraphicalEditPart graphicalEditPart : Iterables.filter((Iterable)containerEditPart.getChildren(), IGraphicalEditPart.class)) {
            Command command = this.buildCommand((GraphicalEditPart)graphicalEditPart, layoutHint);
            if (!command.canExecute()) continue;
            cc.add(command);
        }
        Command command = this.layoutEditParts(containerEditPart.getChildren(), layoutHint);
        if (command.canExecute()) {
            cc.add(command);
        }
        return cc;
    }

    public boolean provides(IOperation operation) {
        return false;
    }

    protected Request findRequest(IGraphicalEditPart editPart, Object requestType) {
        if (editPart != null) {
            return this.findRequest(editPart.getNotationView(), requestType);
        }
        return null;
    }

    protected Request findRequest(View notationView, Object requestType) {
        List<Request> requests = this.getViewsToChangeBoundsRequest().get(notationView);
        Request result = null;
        if (requests != null) {
            Iterator<Request> iterRequests = requests.iterator();
            while (iterRequests.hasNext() && result == null) {
                Request currentRequest = iterRequests.next();
                if (currentRequest.getType() == null || !currentRequest.getType().equals(requestType)) continue;
                result = currentRequest;
            }
        }
        return result;
    }

    protected Command buildCommandWrapper(Request request, EditPart editPart) {
        if (editPart instanceof IGraphicalEditPart) {
            List<Request> requests = this.getViewsToChangeBoundsRequest().get(((IGraphicalEditPart)editPart).getNotationView());
            if (requests == null) {
                requests = new LinkedList<Request>();
                this.getViewsToChangeBoundsRequest().put(((IGraphicalEditPart)editPart).getNotationView(), requests);
            }
            requests.add(request);
        }
        return new CommandWrapper(request, editPart);
    }

    protected boolean isPinned(IGraphicalEditPart part) {
        boolean isPinned = false;
        if (part.resolveSemanticElement() instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)part.resolveSemanticElement();
            isPinned = new PinHelper().isPinned(dDiagramElement);
        }
        return isPinned;
    }

    protected Rectangle getBounds(IGraphicalEditPart graphicalEditPart) {
        ChangeBoundsRequest changeBoundsRequest;
        Request existingRequest = this.findRequest(graphicalEditPart, (Object)"resize");
        Rectangle figureBounds = new Rectangle(graphicalEditPart.getFigure().getBounds());
        if (existingRequest instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)existingRequest).getSizeDelta() != null) {
            this.adjustBounds(figureBounds, changeBoundsRequest);
        }
        if ((existingRequest = this.findRequest(graphicalEditPart, (Object)"move")) instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)existingRequest).getMoveDelta() != null) {
            figureBounds.x += changeBoundsRequest.getMoveDelta().x;
            figureBounds.y += changeBoundsRequest.getMoveDelta().y;
        }
        return figureBounds;
    }

    private void adjustBounds(Rectangle figureBounds, ChangeBoundsRequest changeBoundsRequest) {
        switch (changeBoundsRequest.getResizeDirection()) {
            case 1: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                figureBounds.y -= changeBoundsRequest.getSizeDelta().height;
                break;
            }
            case 4: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                break;
            }
            case 16: {
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
                break;
            }
            case 8: {
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
                figureBounds.x -= changeBoundsRequest.getSizeDelta().width;
                break;
            }
            case 17: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                figureBounds.y -= changeBoundsRequest.getSizeDelta().height;
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
                break;
            }
            case 9: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                figureBounds.y -= changeBoundsRequest.getSizeDelta().height;
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
                figureBounds.x -= changeBoundsRequest.getSizeDelta().width;
                break;
            }
            case 12: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
                figureBounds.x -= changeBoundsRequest.getSizeDelta().width;
                break;
            }
            default: {
                figureBounds.height += changeBoundsRequest.getSizeDelta().height;
                figureBounds.width += changeBoundsRequest.getSizeDelta().width;
            }
        }
    }

    protected IFigure findChild(IFigure searchRoot, Class<?> type) {
        IFigure result = null;
        if (type.isInstance(searchRoot)) {
            result = searchRoot;
        }
        Iterator iterChildren = searchRoot.getChildren().iterator();
        while (iterChildren.hasNext() && result == null) {
            IFigure child = (IFigure)iterChildren.next();
            result = this.findChild(child, type);
        }
        return result;
    }

    public List<EditPart> getAllEditParts(EditPart root) {
        HashSet<EditPart> editParts = new HashSet<EditPart>();
        editParts.add(root);
        if (root instanceof GraphicalEditPart) {
            editParts.addAll(((GraphicalEditPart)root).getSourceConnections());
            editParts.addAll(((GraphicalEditPart)root).getTargetConnections());
        }
        for (EditPart next : root.getChildren()) {
            editParts.addAll(this.getAllEditParts(next));
        }
        return new ArrayList<EditPart>(editParts);
    }

    private static void resetWrappedCommand(Command command) {
        if (command instanceof CommandWrapper) {
            ((CommandWrapper)command).wrappedCommand = null;
        } else if (command instanceof CompoundCommand) {
            Object[] children;
            Object[] objectArray = children = ((CompoundCommand)command).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof Command) {
                    AbstractLayoutProvider.resetWrappedCommand((Command)element);
                }
                ++n2;
            }
        }
    }

    protected static class CommandWrapper
    extends Command {
        private Command wrappedCommand;
        private final Request request;
        private final EditPart editPart;

        public CommandWrapper(Request request, EditPart editPart) {
            this.request = request;
            this.editPart = editPart;
        }

        public void execute() {
            this.getWrappedCommand().execute();
        }

        public boolean canExecute() {
            return this.getWrappedCommand().canExecute();
        }

        public boolean canUndo() {
            return this.getWrappedCommand().canUndo();
        }

        public void undo() {
            this.getWrappedCommand().undo();
        }

        public void redo() {
            this.getWrappedCommand().redo();
        }

        private Command getWrappedCommand() {
            if (this.wrappedCommand == null) {
                Command cmd = this.editPart.getCommand(this.request);
                this.wrappedCommand = cmd == null ? UnexecutableCommand.INSTANCE : cmd;
            }
            return this.wrappedCommand;
        }

        public String getLabel() {
            return this.getWrappedCommand().getLabel();
        }

        public Request getRequest() {
            return this.request;
        }

        public EditPart getEditPart() {
            return this.editPart;
        }
    }
}

