/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles;

import java.text.MessageFormat;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.internal.query.StyleConfigurationQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.BorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.SimpleStyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.swt.graphics.Image;

public class SafeStyleConfiguration
implements StyleConfiguration {
    private static final StyleConfiguration DEFAULT = new SimpleStyleConfiguration();
    private StyleConfiguration delegated;

    public SafeStyleConfiguration(StyleConfiguration delegated) {
        this.delegated = delegated == null ? DEFAULT : delegated;
    }

    @Override
    public void adaptNodeLabel(DNode node, SiriusWrapLabel nodeLabel) {
        try {
            this.delegated.adaptNodeLabel(node, nodeLabel);
        }
        catch (Exception e) {
            this.log(e);
            DEFAULT.adaptNodeLabel(node, nodeLabel);
        }
    }

    @Override
    public int adaptViewNodeSizeWithLabel(DNode viewNode, SiriusWrapLabel nodeLabel, int nodeWidth) {
        try {
            return this.delegated.adaptViewNodeSizeWithLabel(viewNode, nodeLabel, nodeWidth);
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.adaptViewNodeSizeWithLabel(viewNode, nodeLabel, nodeWidth);
        }
    }

    @Override
    public Dimension fitToText(DNode node, SiriusWrapLabel nodeLabel, DefaultSizeNodeFigure defaultSizeNodeFigure) {
        try {
            return this.delegated.fitToText(node, nodeLabel, defaultSizeNodeFigure);
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.fitToText(node, nodeLabel, defaultSizeNodeFigure);
        }
    }

    @Override
    public AnchorProvider getAnchorProvider() {
        try {
            return this.delegated.getAnchorProvider();
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.getAnchorProvider();
        }
    }

    @Override
    public BorderItemLocatorProvider getBorderItemLocatorProvider() {
        try {
            return this.delegated.getBorderItemLocatorProvider();
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.getBorderItemLocatorProvider();
        }
    }

    @Override
    public Image getLabelIcon(DDiagramElement vpElement, IGraphicalEditPart editPart) {
        try {
            return new StyleConfigurationQuery(this.delegated).getLabelIcon(vpElement, editPart);
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.getLabelIcon(vpElement, editPart);
        }
    }

    @Override
    public IBorderItemLocator getNameBorderItemLocator(DNode node, IFigure mainFigure) {
        try {
            return this.delegated.getNameBorderItemLocator(node, mainFigure);
        }
        catch (Exception e) {
            this.log(e);
            return DEFAULT.getNameBorderItemLocator(node, mainFigure);
        }
    }

    private void log(Exception e) {
        DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.SafeStyleConfiguration_customStyleInvocationError, this.delegated.getClass().getName()), (Throwable)e);
    }
}

