/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.internal.refresh.listeners.WorkspaceFileResourceChangeListener;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AbstractTransparentImage;
import org.eclipse.sirius.diagram.ui.tools.api.figure.IWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;

public class WorkspaceImageFigure
extends AbstractTransparentImage
implements IWorkspaceImageFigure {
    private double imageAspectRatio = 1.0;
    private boolean keepAspectRatio = true;

    public WorkspaceImageFigure(Image flyWeightImage) {
        super(flyWeightImage);
        this.imageAspectRatio = (double)flyWeightImage.getBounds().width / (double)flyWeightImage.getBounds().height;
        this.minSize = new Dimension(0, 0);
    }

    public void setSize(int w, int h) {
        if (this.keepAspectRatio) {
            int newHeight = (int)((double)w / this.imageAspectRatio);
            super.setSize(w, newHeight);
        } else {
            super.setSize(w, h);
        }
    }

    public void setMaximumSize(Dimension d) {
        super.setMaximumSize(this.getSize());
    }

    public void setMinimumSize(Dimension d) {
        super.setMinimumSize(this.getSize());
    }

    public void setPreferredSize(Dimension size) {
        super.setPreferredSize(this.getSize());
    }

    public static Image flyWeightImage(String path) {
        if (path != null) {
            File imageFile = WorkspaceFileResourceChangeListener.getInstance().getFileFromURI(path);
            ImageDescriptor desc = null;
            if (imageFile != null && WorkspaceFileResourceChangeListener.getInstance().getReadStatusOfFile(imageFile)) {
                try {
                    desc = WorkspaceFileResourceChangeListener.getInstance().findImageDescriptor(imageFile);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return WorkspaceImageFigure.flyWeightImage(desc);
        }
        return WorkspaceImageFigure.getImageNotFound();
    }

    public static Image flyWeightImage(ImageDescriptor desc) {
        if (desc != null) {
            return DiagramUIPlugin.getPlugin().getImage(desc);
        }
        return WorkspaceImageFigure.getImageNotFound();
    }

    private static Image getImageNotFound() {
        return DiagramUIPlugin.getPlugin().getImage(DiagramUIPlugin.Implementation.findImageWithDimensionDescriptor("/org.eclipse.sirius.common.ui/images/NotFound.png"));
    }

    public static WorkspaceImageFigure createImageFigure(String path) {
        WorkspaceImageFigure fig = new WorkspaceImageFigure(WorkspaceImageFigure.flyWeightImage(path));
        return fig;
    }

    public static WorkspaceImageFigure createImageFigure(WorkspaceImage wksImage) {
        String path = wksImage.getWorkspacePath();
        return WorkspaceImageFigure.createImageFigure(path);
    }

    @Override
    public double getImageAspectRatio() {
        return this.imageAspectRatio;
    }

    @Override
    public void refreshFigure(WorkspaceImage bundledImage) {
        String path = bundledImage.getWorkspacePath();
        Image image = WorkspaceImageFigure.flyWeightImage(path);
        if (!image.equals((Object)this.getImage())) {
            this.setImage(WorkspaceImageFigure.flyWeightImage(path));
            this.repaint();
        }
    }

    @Override
    public void refreshFigure(ContainerStyle containerStyle) {
        if (containerStyle instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)containerStyle;
            this.refreshFigure(workspaceImage);
        }
    }

    public static Image getImageInstanceFromPath(String path) {
        Image image = path != null && WorkspaceImageFigure.isSvgImage(path) ? SVGWorkspaceImageFigure.flyWeightImage(path) : WorkspaceImageFigure.flyWeightImage(path);
        return image;
    }

    public static boolean isSvgImage(String path) {
        if (path == null) {
            return false;
        }
        String pathToUpperCase = path.toUpperCase();
        return pathToUpperCase.endsWith(ImageFileFormat.SVG.getName()) || pathToUpperCase.endsWith(ImageFileFormat.SVGZ.getName());
    }
}

