/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.ZoomDependantAnchor;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.AlphaBasedSlidableImageAnchor;

public class AirDefaultSizeNodeFigure
extends DefaultSizeNodeFigure {
    protected ZoomManager zoomManager;
    private AnchorProvider anchorProvider;
    private double slidableAnchorArea = -1.0;

    public AirDefaultSizeNodeFigure(Dimension defSize, AnchorProvider anchorProvider) {
        super(defSize);
        this.anchorProvider = anchorProvider;
    }

    public AirDefaultSizeNodeFigure(int width, int height, AnchorProvider anchorProvider) {
        super(width, height);
        this.anchorProvider = anchorProvider;
    }

    public ConnectionAnchor createAnchor(AnchorProvider provider, PrecisionPoint p) {
        ConnectionAnchor anchor = provider.createAnchor(this, p);
        this.setZoomManagerToAnchor(anchor);
        return anchor;
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        Object result;
        if (this.anchorProvider != null) {
            ConnectionAnchor anchor = this.anchorProvider.createAnchor(this, p);
            this.setZoomManagerToAnchor(anchor);
            result = anchor;
        } else {
            result = p == null ? this.createDefaultAnchor() : new AlphaBasedSlidableImageAnchor((IFigure)this, p);
        }
        return result;
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        return super.createConnectionAnchor(p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        if (this.anchorProvider != null) {
            ConnectionAnchor anchor = this.anchorProvider.createDefaultAnchor(this);
            this.setZoomManagerToAnchor(anchor);
            return anchor;
        }
        return new AlphaBasedSlidableImageAnchor((IFigure)this);
    }

    private void setZoomManagerToAnchor(ConnectionAnchor anchor) {
        if (anchor instanceof ZoomDependantAnchor) {
            ((ZoomDependantAnchor)anchor).setZoomManager(this.zoomManager);
        }
    }

    public Insets getInsets() {
        return new Insets(0);
    }

    public Dimension getMinimumSize(int hint, int hint2) {
        return new Dimension(10, 10);
    }

    public double getSlidableAnchorArea() {
        if (this.slidableAnchorArea >= 0.0) {
            return this.slidableAnchorArea;
        }
        return super.getSlidableAnchorArea();
    }

    public void setSlidableAnchorArea(double value) {
        this.slidableAnchorArea = value > 1.0 ? 1.0 : value;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public AnchorProvider getAnchorProvider() {
        return this.anchorProvider;
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor connectAnchor = (ConnectionAnchor)this.getConnectionAnchors().get(terminal == null ? "" : terminal);
        if (connectAnchor == null) {
            connectAnchor = "".equals(terminal) ? this.createDefaultAnchor() : this.createAnchor(BaseSlidableAnchor.parseTerminalString((String)terminal));
            this.getConnectionAnchors().put(terminal == null ? "" : terminal, connectAnchor);
        }
        return connectAnchor;
    }

    public void setZoomManager(ZoomManager manager) {
        if (this.zoomManager != manager) {
            this.zoomManager = manager;
            for (ConnectionAnchor anchor : this.getConnectionAnchors().values()) {
                if (!(anchor instanceof ZoomDependantAnchor)) continue;
                ((ZoomDependantAnchor)anchor).setZoomManager(manager);
            }
        }
    }
}

