/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.core.s.util.CoreScoutUtils;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceNewOperation;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.IResourceChangedListener;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;

public class WebServiceNewWizardPage
extends AbstractWizardPage {
    public static final String PROP_WEB_SERVICE_TYPE = "webServiceType";
    public static final String PROP_CONSUMER_WSDL_URL = "consumerWsdlUrl";
    public static final String PROP_PROVIDER_WSDL_URL = "providerWsdlUrl";
    public static final String PROP_PROVIDER_WSDL_NAME = "providerWsdlName";
    public static final String PROP_IS_CREATE_NEW_PROJECT = "isCreateNewProject";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_EXISTING_JAXWS_PROJECT = "jaxwsProject";
    public static final String PROP_SERVER_PROJECT = "serverProject";
    public static final String PROP_ARTIFACT_ID = "artifactId";
    private ResourceTextField m_consumerWsdlUrlField;
    private ResourceTextField m_providerWsdlUrlField;
    private ProposalTextField m_existingJaxWsProjectField;
    private ProposalTextField m_packageField;
    private ProposalTextField m_serverProjectField;
    private StyledTextField m_artifactIdField;
    private StyledTextField m_providerWsdlNameField;
    private Button m_createConsumer;
    private Button m_createProviderFromExistingWsdl;
    private Button m_createProviderFromEmptyWsdl;
    private Button m_createNewProjectButton;
    private Button m_addToExistingProjectButton;
    private URL m_lastParsedWsdlUrl;
    private IStatus m_lastParsedWsdlUrlStatus;
    private boolean m_packageChanged;

    public WebServiceNewWizardPage() {
        super(WebServiceNewWizardPage.class.getName());
        this.setTitle("Create a new Web Service");
        this.setDescription(this.getTitle());
        this.initDefaults();
    }

    protected void initDefaults() {
        this.setPackageChanged(false);
        this.setIsCreateNewProjectInternal(true);
        this.setWebServiceTypeInternal(WebServiceType.CONSUMER_FROM_EXISTING_WSDL);
    }

    @Override
    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        int labelWidth = 130;
        this.createTypeGroup(parent, labelWidth);
        this.createProjectGroup(parent, labelWidth);
        this.createAttributesGroup(parent, labelWidth);
        this.setViewState();
        this.m_consumerWsdlUrlField.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_webservice_page_context");
    }

    protected void createTypeGroup(Composite parent, int labelWidth) {
        Group typeGroupBox = this.getFieldToolkit().createGroupBox(parent, "Type of Web Service");
        this.m_createConsumer = new Button((Composite)typeGroupBox, 16);
        this.m_createConsumer.setText("Create new Web Service Consumer");
        this.m_createConsumer.setSelection(WebServiceType.CONSUMER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType()));
        this.m_createConsumer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.CONSUMER_FROM_EXISTING_WSDL);
                    WebServiceNewWizardPage.this.setViewState();
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_consumerWsdlUrlField = this.getFieldToolkit().createResourceField((Composite)typeGroupBox, "WSDL URL", 1, labelWidth);
        this.m_consumerWsdlUrlField.setText(this.getConsumerWsdlUrl());
        this.m_consumerWsdlUrlField.addResourceChangedListener(new IResourceChangedListener(){

            @Override
            public void resourceChanged(URL newUrl, File newFile) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    String url = null;
                    if (newUrl != null) {
                        url = newUrl.toExternalForm();
                    }
                    WebServiceNewWizardPage.this.setConsumerWsdlUrlInternal(url);
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_createProviderFromExistingWsdl = new Button((Composite)typeGroupBox, 16);
        this.m_createProviderFromExistingWsdl.setText("Create new Web Service Provider from existing WSDL");
        this.m_createProviderFromExistingWsdl.setSelection(WebServiceType.PROVIDER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType()));
        this.m_createProviderFromExistingWsdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.PROVIDER_FROM_EXISTING_WSDL);
                    WebServiceNewWizardPage.this.setViewState();
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_providerWsdlUrlField = this.getFieldToolkit().createResourceField((Composite)typeGroupBox, "WSDL URL", 1, labelWidth);
        this.m_providerWsdlUrlField.setText(this.getProviderWsdlUrl());
        this.m_providerWsdlUrlField.addResourceChangedListener(new IResourceChangedListener(){

            @Override
            public void resourceChanged(URL newUrl, File newFile) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    String url = null;
                    if (newUrl != null) {
                        url = newUrl.toExternalForm();
                    }
                    WebServiceNewWizardPage.this.setProviderWsdlUrlInternal(url);
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_createProviderFromEmptyWsdl = new Button((Composite)typeGroupBox, 16);
        this.m_createProviderFromEmptyWsdl.setText("Create new Web Service Provider with empty WSDL");
        this.m_createProviderFromEmptyWsdl.setSelection(WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)this.getWebServiceType()));
        this.m_createProviderFromEmptyWsdl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setWebServiceTypeInternal(WebServiceType.PROVIDER_FROM_EMPTY_WSDL);
                    WebServiceNewWizardPage.this.setViewState();
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_providerWsdlNameField = this.getFieldToolkit().createStyledTextField((Composite)typeGroupBox, "Web Service Name", 1, labelWidth);
        this.m_providerWsdlNameField.setText(this.getWsdlName());
        this.m_providerWsdlNameField.setReadOnlySuffix("WebService");
        this.m_providerWsdlNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setWsdlNameInternal(WebServiceNewWizardPage.this.m_providerWsdlNameField.getText());
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)typeGroupBox);
        GridDataFactory.defaultsFor((Control)typeGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)typeGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_createConsumer).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createConsumer);
        GridDataFactory.defaultsFor((Control)this.m_consumerWsdlUrlField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_consumerWsdlUrlField);
        GridDataFactory.defaultsFor((Control)this.m_createProviderFromExistingWsdl).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createProviderFromExistingWsdl);
        GridDataFactory.defaultsFor((Control)this.m_providerWsdlUrlField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_providerWsdlUrlField);
        GridDataFactory.defaultsFor((Control)this.m_createProviderFromEmptyWsdl).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createProviderFromEmptyWsdl);
        GridDataFactory.defaultsFor((Control)this.m_providerWsdlNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_providerWsdlNameField);
    }

    protected void createProjectGroup(Composite parent, int labelWidth) {
        Group projectGroupBox = this.getFieldToolkit().createGroupBox(parent, "Target Project");
        this.m_createNewProjectButton = new Button((Composite)projectGroupBox, 16);
        this.m_createNewProjectButton.setText("Create new project for this Web Service");
        this.m_createNewProjectButton.setSelection(this.isCreateNewProject());
        this.m_createNewProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setIsCreateNewProjectInternal(true);
                    WebServiceNewWizardPage.this.setViewState();
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        Predicate<IJavaProject> serverProjectsFilter = new Predicate<IJavaProject>(){

            @Override
            public boolean test(IJavaProject element) {
                return WebServiceNewWizardPage.this.isServerProject(element);
            }
        };
        this.m_serverProjectField = this.getFieldToolkit().createProjectProposalField((Composite)projectGroupBox, "Add new Project to", serverProjectsFilter, labelWidth);
        this.m_serverProjectField.acceptProposal(this.getServerProject());
        this.m_serverProjectField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    IJavaProject jp = (IJavaProject)proposal;
                    WebServiceNewWizardPage.this.setServerProjectInternal(jp);
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_artifactIdField = this.getFieldToolkit().createStyledTextField((Composite)projectGroupBox, "Artifact Id", 1, labelWidth);
        this.m_artifactIdField.setText(this.getArtifactId());
        this.m_artifactIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setArtifactIdInternal(WebServiceNewWizardPage.this.m_artifactIdField.getText());
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_addToExistingProjectButton = new Button((Composite)projectGroupBox, 16);
        this.m_addToExistingProjectButton.setText("Add Web Service to an existing Project");
        this.m_addToExistingProjectButton.setSelection(!this.isCreateNewProject());
        this.m_addToExistingProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setIsCreateNewProjectInternal(false);
                    WebServiceNewWizardPage.this.setViewState();
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        Predicate<IJavaProject> jaxwsProjectsFilter = new Predicate<IJavaProject>(){

            @Override
            public boolean test(IJavaProject element) {
                return WebServiceNewWizardPage.this.isJaxWsProject(element);
            }
        };
        this.m_existingJaxWsProjectField = this.getFieldToolkit().createProjectProposalField((Composite)projectGroupBox, "Web Service Project", jaxwsProjectsFilter, labelWidth);
        this.m_existingJaxWsProjectField.acceptProposal(this.getExistingJaxWsProject());
        this.m_existingJaxWsProjectField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    IJavaProject javaProject = (IJavaProject)proposal;
                    WebServiceNewWizardPage.this.setExistingJaxWsProjectInternal(javaProject);
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)projectGroupBox);
        GridDataFactory.defaultsFor((Control)projectGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)projectGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_createNewProjectButton).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_createNewProjectButton);
        GridDataFactory.defaultsFor((Control)this.m_serverProjectField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_serverProjectField);
        GridDataFactory.defaultsFor((Control)this.m_artifactIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_artifactIdField);
        GridDataFactory.defaultsFor((Control)this.m_addToExistingProjectButton).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_addToExistingProjectButton);
        GridDataFactory.defaultsFor((Control)this.m_existingJaxWsProjectField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_existingJaxWsProjectField);
    }

    protected void createAttributesGroup(Composite parent, int labelWidth) {
        Group attributesGroupBox = this.getFieldToolkit().createGroupBox(parent, "Web Service Artifacts Package");
        this.m_packageField = this.getFieldToolkit().createPackageField((Composite)attributesGroupBox, "Target Package", this.getExistingJaxWsProject(), labelWidth);
        this.m_packageField.setText(this.getTargetPackage());
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WebServiceNewWizardPage.this.isPackageChanged() && !WebServiceNewWizardPage.this.isStateChanging()) {
                    WebServiceNewWizardPage.this.setPackageChanged(true);
                }
                try {
                    WebServiceNewWizardPage.this.setStateChanging(true);
                    WebServiceNewWizardPage.this.setTargetPackageInternal(WebServiceNewWizardPage.this.m_packageField.getText());
                }
                finally {
                    WebServiceNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)attributesGroupBox);
        GridDataFactory.defaultsFor((Control)attributesGroupBox).align(4, 0x1000000).grab(true, false).applyTo((Control)attributesGroupBox);
        GridDataFactory.defaultsFor((Control)this.m_packageField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_packageField);
    }

    protected void guessArtifactId() {
        if (StringUtils.isNotBlank((CharSequence)this.getArtifactId())) {
            return;
        }
        if (!this.isCreateNewProject()) {
            return;
        }
        if (!S2eUtils.exists((IJavaElement)this.getServerProject())) {
            return;
        }
        this.setArtifactId(String.valueOf(this.getServerProject().getElementName()) + ".ws");
    }

    protected void guessPackage() {
        Document pom;
        if (this.isPackageChanged()) {
            return;
        }
        String groupId = null;
        String artifactId = null;
        if (this.isCreateNewProject()) {
            if (StringUtils.isNotBlank((CharSequence)this.getArtifactId()) && S2eUtils.exists((IJavaElement)this.getServerProject())) {
                pom = WebServiceNewWizardPage.getPomDocument(this.getServerProject());
                groupId = CoreScoutUtils.getGroupIdOfPom((Document)pom);
                artifactId = this.getArtifactId();
            }
        } else if (S2eUtils.exists((IJavaElement)this.getExistingJaxWsProject())) {
            pom = WebServiceNewWizardPage.getPomDocument(this.getExistingJaxWsProject());
            groupId = CoreScoutUtils.getGroupIdOfPom((Document)pom);
            artifactId = CoreScoutUtils.getArtifactIdOfPom((Document)pom);
        }
        if (artifactId == null || StringUtils.isBlank(artifactId)) {
            return;
        }
        String baseName = null;
        if (WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)this.getWebServiceType())) {
            baseName = this.getWsdlName();
            if (StringUtils.isNotBlank((CharSequence)baseName)) {
                baseName = JaxWsUtils.removeCommonSuffixes((String)baseName.toLowerCase());
            }
        } else {
            baseName = WebServiceType.PROVIDER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType()) ? WebServiceNewWizardPage.getWebServiceNameFromUrl(this.getProviderWsdlUrl()) : WebServiceNewWizardPage.getWebServiceNameFromUrl(this.getConsumerWsdlUrl());
        }
        if (StringUtils.isBlank((CharSequence)baseName)) {
            return;
        }
        StringBuilder pckBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)groupId) && !artifactId.startsWith(groupId)) {
            pckBuilder.append(groupId);
            pckBuilder.append('.');
        }
        pckBuilder.append(artifactId);
        pckBuilder.append('.');
        pckBuilder.append(baseName);
        this.setTargetPackage(pckBuilder.toString());
    }

    protected static String getWebServiceNameFromUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            String file = new Path(new URL(url).getPath()).lastSegment();
            if (StringUtils.isNotBlank((CharSequence)file)) {
                int lastDotPos = (file = file.toLowerCase()).lastIndexOf(46);
                if (lastDotPos > 0) {
                    file = file.substring(0, lastDotPos);
                }
                return JaxWsUtils.removeCommonSuffixes((String)file);
            }
        }
        catch (MalformedURLException e) {
            SdkLog.debug((String)"Invalid URL passed.", (Object[])new Object[]{e});
        }
        return null;
    }

    protected static Document getPomDocument(IJavaProject project) {
        try {
            return S2eUtils.getPomDocument((IProject)project.getProject());
        }
        catch (CoreException e) {
            SdkLog.debug((String)"Unable to load pom of project '{}'.", (Object[])new Object[]{project.getElementName(), e});
            return null;
        }
    }

    protected boolean isServerProject(IJavaProject jp) {
        try {
            return S2eUtils.exists((IJavaElement)jp.findType("org.eclipse.scout.rt.server.IServerSession")) && !jp.getProject().getFolder("src/main/webapp/WEB-INF").exists() && !WebServiceNewOperation.getWsdlRootFolder((IProject)jp.getProject()).exists();
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Cannot check type of project '{}'. This project will be ignored.", (Object[])new Object[]{jp.getElementName(), e});
            return false;
        }
    }

    protected boolean isJaxWsProject(IJavaProject jp) {
        IFolder wsdlFolder;
        IProject project;
        block9: {
            block8: {
                block7: {
                    block6: {
                        project = jp.getProject();
                        wsdlFolder = WebServiceNewOperation.getWsdlRootFolder((IProject)project);
                        if (wsdlFolder.exists()) break block6;
                        return false;
                    }
                    IFolder bindingFolder = WebServiceNewOperation.getBindingRootFolder((IProject)project);
                    if (bindingFolder.exists()) break block7;
                    return false;
                }
                IPackageFragmentRoot primarySourceFolder = S2eUtils.getPrimarySourceFolder((IJavaProject)jp);
                if (S2eUtils.exists((IJavaElement)primarySourceFolder) && primarySourceFolder.getResource().getProjectRelativePath().toString().toLowerCase().contains("java")) break block8;
                return false;
            }
            if (S2eUtils.exists((IJavaElement)jp.findType("org.eclipse.scout.rt.server.jaxws.consumer.AbstractWebServiceClient"))) break block9;
            return false;
        }
        try {
            String prefix = "p";
            String p = "p:";
            StringBuilder bindingFilesXpathBuilder = new StringBuilder();
            bindingFilesXpathBuilder.append("p:").append("project").append('/').append("p:").append("build").append('/').append("p:").append("plugins").append('/').append("p:").append("plugin").append("[./").append("p:").append("groupId").append("='").append("org.codehaus.mojo").append("' and ./").append("p:").append(PROP_ARTIFACT_ID).append("='").append("jaxws-maven-plugin").append("']");
            List elements = CoreUtils.evaluateXPath((String)bindingFilesXpathBuilder.toString(), (Document)S2eUtils.getPomDocument((IProject)project), (String)"p", (String)"http://maven.apache.org/POM/4.0.0");
            return !elements.isEmpty() || !WebServiceNewWizardPage.containsWsdls(wsdlFolder);
        }
        catch (XPathExpressionException | CoreException e) {
            SdkLog.warning((String)"Cannot check type of project '{}'. This project will be ignored.", (Object[])new Object[]{jp.getElementName(), e});
            return false;
        }
    }

    protected static boolean containsWsdls(IFolder wsdlFolder) {
        final boolean[] result = new boolean[1];
        try {
            wsdlFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && proxy.getName().endsWith(".wsdl")) {
                        result[0] = true;
                    }
                    return !result[0];
                }
            }, 0);
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Unable to search WSDL files in project '{}'.", (Object[])new Object[]{wsdlFolder.getProject().getName(), e});
            return false;
        }
        return result[0];
    }

    protected void setViewState() {
        this.m_artifactIdField.setEnabled(this.isCreateNewProject());
        this.m_serverProjectField.setEnabled(this.isCreateNewProject());
        this.m_existingJaxWsProjectField.setEnabled(!this.isCreateNewProject());
        this.m_consumerWsdlUrlField.setEnabled(WebServiceType.CONSUMER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType()));
        this.m_providerWsdlUrlField.setEnabled(WebServiceType.PROVIDER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType()));
        this.m_providerWsdlNameField.setEnabled(WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)this.getWebServiceType()));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusWsdlUrl());
        multiStatus.add(this.getStatusWsdlName());
        multiStatus.add(this.getStatusServerProject());
        multiStatus.add(this.getStatusArtifactId());
        multiStatus.add(this.getStatusExistingJaxWsProject());
        multiStatus.add(this.getStatusPackage());
    }

    protected IStatus getStatusPackage() {
        return CompilationUnitNewWizardPage.validatePackageName(this.getTargetPackage());
    }

    protected IStatus getStatusWsdlName() {
        if (!WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)this.getWebServiceType())) {
            return Status.OK_STATUS;
        }
        return CompilationUnitNewWizardPage.validateJavaName(this.getWsdlName(), this.m_providerWsdlNameField.getReadOnlySuffix());
    }

    protected IStatus getStatusExistingJaxWsProject() {
        if (this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        if (!S2eUtils.exists((IJavaElement)this.getExistingJaxWsProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose the project in which the new Web Service should be created.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusServerProject() {
        if (!this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        if (!S2eUtils.exists((IJavaElement)this.getServerProject())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose for which server project a new Web Service project should be created.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusArtifactId() {
        if (!this.isCreateNewProject()) {
            return Status.OK_STATUS;
        }
        String msg = ScoutProjectNewHelper.getMavenNameErrorMessage((String)this.getArtifactId(), (String)"Artifact Id");
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equalsIgnoreCase(this.getArtifactId())) {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in the workspace.");
            }
            ++n2;
        }
        if (S2eUtils.exists((IJavaElement)this.getServerProject())) {
            File serverProjectFolder = this.getServerProject().getProject().getLocation().makeAbsolute().toFile();
            File targetDir = serverProjectFolder.getParentFile();
            if (targetDir != null) {
                if (new File(targetDir, this.getArtifactId()).isDirectory()) {
                    return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in this target directory.");
                }
            } else {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Invalid project location.");
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusWsdlUrl() {
        String wsdlUrl = null;
        ResourceTextField fieldToCheck = null;
        if (WebServiceType.CONSUMER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType())) {
            fieldToCheck = this.m_consumerWsdlUrlField;
            wsdlUrl = this.getConsumerWsdlUrl();
        } else if (WebServiceType.PROVIDER_FROM_EXISTING_WSDL.equals((Object)this.getWebServiceType())) {
            fieldToCheck = this.m_providerWsdlUrlField;
            wsdlUrl = this.getProviderWsdlUrl();
        } else {
            return Status.OK_STATUS;
        }
        if (StringUtils.isBlank((CharSequence)wsdlUrl)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please specify a WSDL URL.");
        }
        try {
            final URL url = new URL(wsdlUrl);
            if (Objects.equals(this.m_lastParsedWsdlUrl, url)) {
                return this.m_lastParsedWsdlUrlStatus;
            }
            final ResourceTextField currentUrlField = fieldToCheck;
            currentUrlField.setEnabled(false);
            AbstractJob parseRemoteWsdl = new AbstractJob("parse WSDL"){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        String msg = WebServiceNewWizardPage.this.validateWsdl(url);
                        WebServiceNewWizardPage.this.m_lastParsedWsdlUrl = url;
                        if (msg == null) {
                            WebServiceNewWizardPage.this.m_lastParsedWsdlUrlStatus = Status.OK_STATUS;
                        } else {
                            WebServiceNewWizardPage.this.m_lastParsedWsdlUrlStatus = (IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", msg);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!currentUrlField.isDisposed()) {
                            currentUrlField.getDisplay().asyncExec(new Runnable(currentUrlField){
                                private final /* synthetic */ ResourceTextField val$currentUrlField;
                                {
                                    this.val$currentUrlField = resourceTextField;
                                }

                                @Override
                                public void run() {
                                    if (!this.val$currentUrlField.isDisposed()) {
                                        WebServiceNewWizardPage.this.revalidate();
                                        this.val$currentUrlField.setEnabled(true);
                                    }
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (!currentUrlField.isDisposed()) {
                        currentUrlField.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            };
            parseRemoteWsdl.setSystem(true);
            parseRemoteWsdl.setUser(false);
            parseRemoteWsdl.schedule();
        }
        catch (MalformedURLException e) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The given WSDL URL is not valid.");
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String validateWsdl(URL url) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = url.openStream();){
                ParsedWsdl info = ParsedWsdl.create((URI)url.toURI(), (InputStream)in);
                if (!info.isEmpty()) return null;
                return "Either this Web Service uses SOAP encoding (use=encoded) or contains no operations. Ensure the Web Service uses literal encoding.";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            SdkLog.debug((Object[])new Object[]{e});
            return "The given WSDL cannot be parsed.";
        }
    }

    public boolean isCreateNewProject() {
        return this.getProperty(PROP_IS_CREATE_NEW_PROJECT, Boolean.class);
    }

    public void setIsCreateNewProject(boolean createNewProject) {
        try {
            this.setStateChanging(true);
            this.setIsCreateNewProjectInternal(createNewProject);
            if (this.isControlCreated()) {
                this.m_createNewProjectButton.setSelection(createNewProject);
                this.m_addToExistingProjectButton.setSelection(!createNewProject);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIsCreateNewProjectInternal(boolean createNewProject) {
        this.setProperty(PROP_IS_CREATE_NEW_PROJECT, createNewProject);
    }

    public String getTargetPackage() {
        return this.getProperty(PROP_TARGET_PACKAGE, String.class);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_packageField != null) {
                this.m_packageField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public IJavaProject getExistingJaxWsProject() {
        return this.getProperty(PROP_EXISTING_JAXWS_PROJECT, IJavaProject.class);
    }

    public void setExistingJaxWsProject(IJavaProject jp) {
        try {
            this.setStateChanging(true);
            this.setExistingJaxWsProjectInternal(jp);
            if (this.isControlCreated()) {
                this.m_existingJaxWsProjectField.acceptProposal(jp);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setExistingJaxWsProjectInternal(IJavaProject jp) {
        if (this.setProperty(PROP_EXISTING_JAXWS_PROJECT, jp)) {
            if (this.isControlCreated()) {
                ((PackageContentProvider)this.m_packageField.getContentProvider()).setJavaProject(jp);
            }
            this.guessPackage();
        }
    }

    public String getConsumerWsdlUrl() {
        return this.getProperty(PROP_CONSUMER_WSDL_URL, String.class);
    }

    public void setConsumerWsdlUrl(String wsdlUrl) {
        try {
            this.setStateChanging(true);
            this.setConsumerWsdlUrlInternal(wsdlUrl);
            if (this.isControlCreated()) {
                this.m_consumerWsdlUrlField.setText(wsdlUrl);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setConsumerWsdlUrlInternal(String wsdlUrl) {
        if (this.setProperty(PROP_CONSUMER_WSDL_URL, wsdlUrl)) {
            this.guessPackage();
        }
    }

    public String getArtifactId() {
        return this.getPropertyString(PROP_ARTIFACT_ID);
    }

    public void setArtifactId(String s) {
        try {
            this.setStateChanging(true);
            this.setArtifactIdInternal(s);
            if (this.isControlCreated()) {
                this.m_artifactIdField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setArtifactIdInternal(String s) {
        if (this.setPropertyString(PROP_ARTIFACT_ID, s)) {
            this.guessPackage();
        }
    }

    public IJavaProject getServerProject() {
        return this.getProperty(PROP_SERVER_PROJECT, IJavaProject.class);
    }

    public void setServerProject(IJavaProject jp) {
        try {
            this.setStateChanging(true);
            this.setServerProjectInternal(jp);
            if (this.isControlCreated()) {
                this.m_serverProjectField.acceptProposal(jp);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServerProjectInternal(IJavaProject jp) {
        if (this.setProperty(PROP_SERVER_PROJECT, jp)) {
            this.guessArtifactId();
            this.guessPackage();
        }
    }

    public WebServiceType getWebServiceType() {
        return this.getProperty(PROP_WEB_SERVICE_TYPE, WebServiceType.class);
    }

    public void setWebServiceType(WebServiceType type) {
        try {
            this.setStateChanging(true);
            this.setWebServiceTypeInternal(type);
            if (this.isControlCreated()) {
                this.m_createConsumer.setSelection(WebServiceType.CONSUMER_FROM_EXISTING_WSDL.equals((Object)type));
                this.m_createProviderFromExistingWsdl.setSelection(WebServiceType.PROVIDER_FROM_EXISTING_WSDL.equals((Object)type));
                this.m_createProviderFromEmptyWsdl.setSelection(WebServiceType.PROVIDER_FROM_EMPTY_WSDL.equals((Object)type));
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setWebServiceTypeInternal(WebServiceType type) {
        this.setProperty(PROP_WEB_SERVICE_TYPE, (Object)type);
    }

    public String getWsdlName() {
        return this.getPropertyString(PROP_PROVIDER_WSDL_NAME);
    }

    public void setWsdlName(String s) {
        try {
            this.setStateChanging(true);
            this.setWsdlNameInternal(s);
            if (this.isControlCreated()) {
                this.m_providerWsdlNameField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setWsdlNameInternal(String s) {
        if (this.setPropertyString(PROP_PROVIDER_WSDL_NAME, s)) {
            this.guessPackage();
        }
    }

    public String getProviderWsdlUrl() {
        return this.getProperty(PROP_PROVIDER_WSDL_URL, String.class);
    }

    public void setProviderWsdlUrl(String wsdlUrl) {
        try {
            this.setStateChanging(true);
            this.setProviderWsdlUrlInternal(wsdlUrl);
            if (this.isControlCreated()) {
                this.m_providerWsdlUrlField.setText(wsdlUrl);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setProviderWsdlUrlInternal(String wsdlUrl) {
        if (this.setProperty(PROP_PROVIDER_WSDL_URL, wsdlUrl)) {
            this.guessPackage();
        }
    }

    protected boolean isPackageChanged() {
        return this.m_packageChanged;
    }

    protected void setPackageChanged(boolean packageChanged) {
        this.m_packageChanged = packageChanged;
    }

    public static enum WebServiceType {
        CONSUMER_FROM_EXISTING_WSDL,
        PROVIDER_FROM_EXISTING_WSDL,
        PROVIDER_FROM_EMPTY_WSDL;

    }
}

