/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodeDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsContentNodePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPageDef;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPagePart;
import org.eclipse.sapphire.ui.forms.MasterDetailsEditorPageState;
import org.eclipse.sapphire.ui.forms.MasterDetailsNodeState;
import org.eclipse.sapphire.util.ListFactory;

public final class MasterDetailsContentOutline
implements Disposable {
    private final MasterDetailsEditorPagePart editorPagePart;
    private final MasterDetailsEditorPageDef editorPageDef;
    private final Element rootModelElement;
    private MasterDetailsContentNodePart root;
    private List<MasterDetailsContentNodePart> selection;
    private final ListenerContext listeners;
    private String filterText;

    public MasterDetailsContentOutline(MasterDetailsEditorPagePart editorPagePart) {
        this.editorPagePart = editorPagePart;
        this.editorPageDef = editorPagePart.definition();
        this.rootModelElement = editorPagePart.getModelElement();
        this.selection = Collections.emptyList();
        this.listeners = new ListenerContext();
        this.filterText = "";
    }

    public MasterDetailsContentNodePart getRoot() {
        if (this.root == null) {
            MasterDetailsContentNodeDef rootNodeDef = this.editorPageDef.getRootNode();
            this.root = new MasterDetailsContentNodePart();
            this.root.init(this.editorPagePart, this.rootModelElement, rootNodeDef, Collections.emptyMap());
            this.root.initialize();
            this.loadTreeState();
            this.attach(new Listener(){

                public void handle(Event event) {
                    if (event instanceof NodeExpandedStateChangedEvent || event instanceof SelectionChangedEvent) {
                        MasterDetailsContentOutline.this.saveTreeState();
                    }
                }
            });
        }
        return this.root;
    }

    public MasterDetailsContentNodePart getSelectedNode() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public List<MasterDetailsContentNodePart> getSelectedNodes() {
        return this.selection;
    }

    public void setSelectedNode(MasterDetailsContentNodePart selection) {
        if (selection == null) {
            this.setSelectedNodes(Collections.emptyList());
        } else {
            this.setSelectedNodes(Collections.singletonList(selection));
        }
    }

    public void setSelectedNodes(List<MasterDetailsContentNodePart> selection) {
        if (!this.selection.equals(selection)) {
            for (MasterDetailsContentNodePart node : selection) {
                MasterDetailsContentNodePart parent = node.getParentNode();
                if (parent == null) continue;
                parent.setExpanded(true);
            }
            this.selection = selection.isEmpty() ? Collections.emptyList() : new ArrayList<MasterDetailsContentNodePart>(selection);
            this.listeners.broadcast((Event)new SelectionChangedEvent(this.selection));
        }
    }

    public void setSelection(String path) {
        MasterDetailsContentNodePart node = this.root;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            boolean segmentMatched = false;
            for (MasterDetailsContentNodePart n3 : node.nodes().visible()) {
                if (!n3.getLabel().equals(segment)) continue;
                node = n3;
                segmentMatched = true;
                break;
            }
            if (!segmentMatched) break;
            ++n2;
        }
        if (node != this.root) {
            this.setSelectedNode(node);
        }
    }

    void refreshSelection() {
        ArrayList<MasterDetailsContentNodePart> newSelection = new ArrayList<MasterDetailsContentNodePart>();
        for (MasterDetailsContentNodePart node : this.selection) {
            LinkedList<MasterDetailsContentNodePart> path = new LinkedList<MasterDetailsContentNodePart>();
            while (node != this.root) {
                path.addFirst(node);
                node = node.getParentNode();
            }
            node = this.root;
            for (MasterDetailsContentNodePart n : path) {
                if (!node.nodes().visible().contains(n)) break;
                node = n;
            }
            if (node == this.root) {
                List<MasterDetailsContentNodePart> topLevelNodes = this.root.nodes().visible();
                node = topLevelNodes.size() > 0 ? topLevelNodes.get(0) : null;
            }
            if (newSelection.contains(node)) continue;
            newSelection.add(node);
        }
        this.setSelectedNodes(newSelection);
    }

    public List<MasterDetailsContentNodePart> getExpandedNodes() {
        ArrayList<MasterDetailsContentNodePart> result = new ArrayList<MasterDetailsContentNodePart>();
        for (MasterDetailsContentNodePart node : this.root.nodes().visible()) {
            node.getExpandedNodes(result);
        }
        return result;
    }

    public void setExpandedNodes(Set<MasterDetailsContentNodePart> expandedNodes) {
        for (MasterDetailsContentNodePart node : this.root.nodes().visible()) {
            MasterDetailsContentOutline.setExpandedNodes(node, expandedNodes);
        }
    }

    private static void setExpandedNodes(MasterDetailsContentNodePart node, Set<MasterDetailsContentNodePart> expandedNodes) {
        for (MasterDetailsContentNodePart child : node.nodes().visible()) {
            MasterDetailsContentOutline.setExpandedNodes(child, expandedNodes);
        }
        boolean shouldBeExpanded = expandedNodes.contains(node);
        if (node.isExpanded() != shouldBeExpanded) {
            node.setExpanded(shouldBeExpanded);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        if (!this.filterText.equals(filterText)) {
            this.filterText = filterText;
            this.listeners.broadcast((Event)new FilterChangedEvent(filterText));
        }
    }

    public final ListenerContext listeners() {
        return this.listeners;
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    public void notifyOfNodeExpandedStateChange(MasterDetailsContentNodePart node) {
        this.listeners.broadcast((Event)new NodeExpandedStateChangedEvent(node));
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    private void loadTreeState() {
        ArrayList<MasterDetailsContentNodePart> selection = new ArrayList<MasterDetailsContentNodePart>();
        MasterDetailsEditorPageState editorPageState = this.editorPagePart.state();
        if (editorPageState != null) {
            MasterDetailsNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            for (MasterDetailsContentNodePart node : this.root.nodes().visible()) {
                this.loadTreeState(rootNodeState, node, selection);
            }
        }
        if (!selection.isEmpty()) {
            this.setSelectedNodes(selection);
        } else {
            MasterDetailsContentNodePart node = this.root;
            String defaultInitialNodePath = this.editorPageDef.getInitialSelectionPath().text();
            if (defaultInitialNodePath != null) {
                String[] stringArray = defaultInitialNodePath.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if ((node = node.findNode(segment)) == null || !node.visible()) break;
                    node.setExpanded(true);
                    ++n2;
                }
            }
            if (node != null) {
                this.setSelectedNode(node);
            }
        }
    }

    private void loadTreeState(MasterDetailsNodeState parentNodeState, MasterDetailsContentNodePart node, List<MasterDetailsContentNodePart> selection) {
        String nodeLabel = node.getLabel();
        for (MasterDetailsNodeState childNodeState : parentNodeState.getChildren()) {
            if (!nodeLabel.equals(childNodeState.getLabel().text())) continue;
            node.setExpanded((Boolean)childNodeState.getExpanded().content());
            if (((Boolean)childNodeState.getSelected().content()).booleanValue()) {
                selection.add(node);
            }
            for (MasterDetailsContentNodePart child : node.nodes().visible()) {
                this.loadTreeState(childNodeState, child, selection);
            }
        }
    }

    private void saveTreeState() {
        MasterDetailsEditorPageState editorPageState = this.editorPagePart.state();
        if (editorPageState != null) {
            MasterDetailsNodeState rootNodeState = editorPageState.getContentOutlineState().getRoot();
            rootNodeState.getChildren().clear();
            List<MasterDetailsContentNodePart> selection = this.getSelectedNodes();
            for (MasterDetailsContentNodePart node : this.root.nodes().visible()) {
                this.saveTreeState(rootNodeState, node, selection);
            }
        }
    }

    private void saveTreeState(MasterDetailsNodeState parentNodeState, MasterDetailsContentNodePart node, List<MasterDetailsContentNodePart> selection) {
        boolean isExpanded = node.isExpanded();
        boolean isSelected = selection.contains(node);
        if (isExpanded || isSelected) {
            MasterDetailsNodeState childNodeState = (MasterDetailsNodeState)parentNodeState.getChildren().insert();
            childNodeState.setLabel(node.getLabel());
            if (isExpanded) {
                childNodeState.setExpanded(isExpanded);
            }
            if (isSelected) {
                childNodeState.setSelected(isSelected);
            }
            for (MasterDetailsContentNodePart child : node.nodes().visible()) {
                this.saveTreeState(childNodeState, child, selection);
            }
        }
    }

    public static final class FilterChangedEvent
    extends Event {
        private final String filter;

        public FilterChangedEvent(String filter) {
            this.filter = filter;
        }

        public String filter() {
            return this.filter;
        }
    }

    public static final class NodeExpandedStateChangedEvent
    extends Event {
        private final MasterDetailsContentNodePart node;

        public NodeExpandedStateChangedEvent(MasterDetailsContentNodePart node) {
            this.node = node;
        }

        public MasterDetailsContentNodePart node() {
            return this.node;
        }
    }

    public static final class SelectionChangedEvent
    extends Event {
        private final List<MasterDetailsContentNodePart> selection;

        public SelectionChangedEvent(List<MasterDetailsContentNodePart> selection) {
            this.selection = ListFactory.unmodifiable(selection);
        }

        public List<MasterDetailsContentNodePart> selection() {
            return this.selection;
        }

        public boolean supersedes(Event event) {
            return event instanceof SelectionChangedEvent;
        }
    }
}

