/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core.commands;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.remote.internal.proxy.core.ProxyConnection;
import org.eclipse.remote.internal.proxy.core.commands.AbstractCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.exceptions.ProxyException;

public class GetOutputStreamCommand
extends AbstractCommand<OutputStream> {
    private final DataOutputStream out;
    private final DataInputStream in;
    private final int options;
    private final String path;

    public GetOutputStreamCommand(ProxyConnection conn, int options, String path) {
        super(conn);
        this.out = new DataOutputStream(conn.getCommandChannel().getOutputStream());
        this.in = new DataInputStream(conn.getCommandChannel().getInputStream());
        this.options = options;
        this.path = path;
    }

    @Override
    public OutputStream call() throws ProxyException {
        try {
            StreamChannel chan = this.openChannel();
            this.out.writeByte(1);
            this.out.writeShort(109);
            this.out.writeByte(chan.getId());
            this.out.writeInt(this.options);
            this.out.writeUTF(this.path);
            this.out.flush();
            byte res = this.in.readByte();
            if (res != 0) {
                String errMsg = this.in.readUTF();
                System.err.println("getoutputstream command failed:" + errMsg);
                throw new ProxyException(errMsg);
            }
            return new BufferedOutputStream(chan.getOutputStream());
        }
        catch (IOException e) {
            throw new ProxyException(e.getMessage());
        }
    }
}

