/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.calls;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeBuilder;
import org.eclipse.recommenders.jayes.io.jbif.JayesBifReader;
import org.eclipse.recommenders.jayes.util.triangulation.IEliminationHeuristic;
import org.eclipse.recommenders.jayes.util.triangulation.MinDegree;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;

@Beta
public class JayesCallModel
implements ICallModel {
    private final BayesNet net;
    private final BayesNode callgroupNode;
    private final BayesNode overridesNode;
    private final BayesNode definedByNode;
    private final BayesNode defKindNode;
    private final JunctionTreeAlgorithm junctionTree;
    private final ITypeName typeName;
    private final Map<IMethodName, BayesNode> callNodes;
    private static final List<String> SPECIAL_NODES = Arrays.asList("contexts", "patterns", "kinds", "definitions");

    public static ICallModel load(InputStream is, ITypeName type) throws IOException {
        BayesNet net = JayesCallModel.getModel(is, type);
        return new JayesCallModel(type, net);
    }

    private static BayesNet getModel(InputStream is, ITypeName type) throws IOException {
        JayesBifReader rdr = new JayesBifReader(is);
        try {
            BayesNet bayesNet = rdr.read();
            return bayesNet;
        }
        finally {
            IOUtils.closeQuietly((Closeable)rdr);
        }
    }

    public JayesCallModel(ITypeName name, BayesNet net) {
        this.net = net;
        this.typeName = name;
        this.callNodes = new HashMap<IMethodName, BayesNode>();
        this.junctionTree = new JunctionTreeAlgorithm();
        this.junctionTree.setJunctionTreeBuilder(JunctionTreeBuilder.forHeuristic((IEliminationHeuristic)new MinDegree()));
        this.junctionTree.setNetwork(net);
        this.overridesNode = net.getNode("contexts");
        this.callgroupNode = net.getNode("patterns");
        this.defKindNode = net.getNode("kinds");
        this.definedByNode = net.getNode("definitions");
        this.setCallNodes(net);
    }

    private void setCallNodes(BayesNet net) {
        for (BayesNode bayesNode : net.getNodes()) {
            String name = bayesNode.getName();
            if (SPECIAL_NODES.contains(name)) continue;
            VmMethodName vmMethodName = VmMethodName.get((String)name);
            this.callNodes.put((IMethodName)vmMethodName, bayesNode);
        }
    }

    private Optional<IMethodName> computeMethodNameFromState(BayesNode node) {
        String stateId = (String)this.junctionTree.getEvidence().get(node);
        if (stateId == null) {
            return Optional.absent();
        }
        return Optional.of((Object)VmMethodName.get((String)stateId));
    }

    @Override
    public ImmutableSet<IMethodName> getKnownCalls() {
        return ImmutableSet.builder().addAll(this.callNodes.keySet()).build();
    }

    @Override
    public ImmutableSet<IMethodName> getKnownOverrideContexts() {
        Collection tmp = Collections2.transform((Collection)this.overridesNode.getOutcomes(), (Function)new StringToMethodNameFunction());
        return ImmutableSet.copyOf((Collection)tmp);
    }

    @Override
    public ImmutableSet<IMethodName> getKnownDefiningMethods() {
        Collection tmp = Collections2.transform((Collection)this.definedByNode.getOutcomes(), (Function)new StringToMethodNameFunction());
        return ImmutableSet.copyOf((Collection)tmp);
    }

    @Override
    public ImmutableSet<ICallModel.DefinitionKind> getKnownDefinitionKinds() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (String s : this.defKindNode.getOutcomes()) {
            b.add((Object)ICallModel.DefinitionKind.valueOf(s));
        }
        return b.build();
    }

    @Override
    public ImmutableSet<String> getKnownPatterns() {
        return ImmutableSet.copyOf((Collection)this.callgroupNode.getOutcomes());
    }

    @Override
    public ImmutableSet<IMethodName> getObservedCalls() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Map evidence = this.junctionTree.getEvidence();
        for (Map.Entry<IMethodName, BayesNode> pair : this.callNodes.entrySet()) {
            BayesNode node = pair.getValue();
            IMethodName method = pair.getKey();
            if (!evidence.containsKey(node) || !((String)evidence.get(node)).equals("true") || VmMethodName.NULL.equals(method)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    @Override
    public Optional<IMethodName> getObservedDefiningMethod() {
        return this.computeMethodNameFromState(this.definedByNode);
    }

    @Override
    public Optional<IMethodName> getObservedOverrideContext() {
        return this.computeMethodNameFromState(this.overridesNode);
    }

    @Override
    public Optional<ICallModel.DefinitionKind> getObservedDefinitionKind() {
        String stateId = (String)this.junctionTree.getEvidence().get(this.defKindNode);
        if (stateId == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)ICallModel.DefinitionKind.valueOf(stateId)));
    }

    @Override
    public List<Recommendation<IMethodName>> recommendCalls() {
        LinkedList<Recommendation<IMethodName>> recs = new LinkedList<Recommendation<IMethodName>>();
        for (Map.Entry<IMethodName, BayesNode> entry : this.callNodes.entrySet()) {
            IMethodName method = entry.getKey();
            BayesNode bayesNode = entry.getValue();
            boolean isAlreadyUsedAsEvidence = this.junctionTree.getEvidence().containsKey(bayesNode);
            if (isAlreadyUsedAsEvidence) continue;
            int indexForTrue = bayesNode.getOutcomeIndex("true");
            double[] probabilities = this.junctionTree.getBeliefs(bayesNode);
            double probability = probabilities[indexForTrue];
            recs.add((Recommendation<IMethodName>)Recommendation.newRecommendation((Object)method, (double)probability));
        }
        return recs;
    }

    @Override
    public List<Recommendation<IMethodName>> recommendDefinitions() {
        LinkedList<Recommendation<IMethodName>> recs = new LinkedList<Recommendation<IMethodName>>();
        double[] beliefs = this.junctionTree.getBeliefs(this.definedByNode);
        int i = this.definedByNode.getOutcomeCount();
        while (i-- > 0) {
            String outcomeName;
            if (!(beliefs[i] > 0.01) || (outcomeName = this.definedByNode.getOutcomeName(i)).equals(Constants.NONE_METHOD.getIdentifier()) || outcomeName.equals(Constants.UNKNOWN_METHOD.getIdentifier())) continue;
            VmMethodName definition = VmMethodName.get((String)outcomeName);
            Recommendation r = Recommendation.newRecommendation((Object)definition, (double)beliefs[i]);
            recs.add((Recommendation<IMethodName>)r);
        }
        return recs;
    }

    @Override
    public List<Recommendation<String>> recommendPatterns() {
        LinkedList<Recommendation<String>> recs = new LinkedList<Recommendation<String>>();
        double[] probs = this.junctionTree.getBeliefs(this.callgroupNode);
        for (String outcome : this.callgroupNode.getOutcomes()) {
            int probIndex = this.callgroupNode.getOutcomeIndex(outcome);
            double p = probs[probIndex];
            recs.add((Recommendation<String>)Recommendation.newRecommendation((Object)outcome, (double)p));
        }
        return recs;
    }

    @Override
    public ITypeName getReceiverType() {
        return this.typeName;
    }

    @Override
    public void reset() {
        this.junctionTree.getEvidence().clear();
    }

    @Override
    public boolean setObservedCalls(Set<IMethodName> calls) {
        for (IMethodName m : this.getObservedCalls()) {
            this.setCalled(m, null);
        }
        if (calls == null) {
            return true;
        }
        boolean pass = true;
        for (IMethodName m : calls) {
            pass &= this.setCalled(m, "true");
        }
        return pass;
    }

    @Override
    public boolean setObservedDefiningMethod(IMethodName newDefinition) {
        if (newDefinition == null) {
            this.junctionTree.removeEvidence(this.definedByNode);
            return true;
        }
        String identifier = newDefinition.getIdentifier();
        boolean contains = this.definedByNode.getOutcomes().contains(identifier);
        if (contains) {
            this.junctionTree.addEvidence(this.definedByNode, identifier);
        }
        return contains;
    }

    @Override
    public boolean setObservedOverrideContext(IMethodName newEnclosingMethod) {
        if (newEnclosingMethod == null) {
            this.junctionTree.removeEvidence(this.overridesNode);
            return true;
        }
        String id = newEnclosingMethod.getIdentifier();
        boolean contains = this.overridesNode.getOutcomes().contains(id);
        if (contains) {
            this.junctionTree.addEvidence(this.overridesNode, id);
        }
        return contains;
    }

    @Override
    public boolean setObservedDefinitionKind(ICallModel.DefinitionKind newDef) {
        if (newDef == null) {
            this.junctionTree.removeEvidence(this.defKindNode);
            return true;
        }
        String identifier = newDef.toString();
        boolean contains = this.defKindNode.getOutcomes().contains(identifier);
        if (contains) {
            this.junctionTree.addEvidence(this.defKindNode, identifier);
        }
        return contains;
    }

    @Override
    public boolean setObservedPattern(String patternName) {
        if (patternName == null) {
            this.junctionTree.removeEvidence(this.callgroupNode);
            return true;
        }
        boolean contains = this.callgroupNode.getOutcomes().contains(patternName);
        if (contains) {
            this.junctionTree.addEvidence(this.callgroupNode, patternName);
        }
        return contains;
    }

    private boolean setCalled(IMethodName m, String state) {
        VmMethodName rebased = VmMethodName.rebase((ITypeName)this.typeName, (IMethodName)m);
        BayesNode node = this.net.getNode(rebased.getIdentifier());
        if (node == null) {
            return false;
        }
        if (state == null) {
            this.junctionTree.removeEvidence(node);
        } else {
            this.junctionTree.addEvidence(node, state);
        }
        return true;
    }

    private static final class StringToMethodNameFunction
    implements Function<String, IMethodName> {
        private StringToMethodNameFunction() {
        }

        public IMethodName apply(String input) {
            return VmMethodName.get((String)input);
        }
    }
}

