/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.nio.ByteBuffer;

public class VarInt {
    private int fValue = 0;
    private boolean fValid = false;
    private ByteBuffer fBytes = null;

    public VarInt(ByteBuffer buffer) {
        int shift = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            this.fValue |= (b & 0x7F) << shift;
            shift += 7;
            if ((b & 0x80) != 0) continue;
            this.fValid = true;
            break;
        }
    }

    public VarInt(int value) {
        this.fValue = value;
        this.fValid = true;
    }

    public ByteBuffer getBytes() {
        if (this.fBytes == null && this.fValid) {
            this.fBytes = ByteBuffer.allocate(5);
            int val = this.fValue;
            do {
                byte b = (byte)(val & 0x7F);
                if ((val >>= 7) != 0) {
                    b = (byte)(b | 0x80);
                }
                this.fBytes.put(b);
            } while (val != 0);
            this.fBytes.limit(this.fBytes.position());
        }
        this.fBytes.rewind();
        return this.fBytes;
    }

    public int getValue() {
        return this.fValue;
    }

    public boolean isValid() {
        return this.fValid;
    }
}

