/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal.rulesengine;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.internal.rulesengine.DownloadBackRule;
import org.eclipse.ptp.launch.internal.rulesengine.UploadRule;
import org.eclipse.ptp.launch.rulesengine.IRuleAction;
import org.eclipse.remote.core.IRemoteFileService;

public class UploadRuleAction
implements IRuleAction {
    private final UploadRule fRule;
    private final ILaunchConfiguration fConfiguration;
    private DownloadBackRule fDownloadBackRule;
    private final IProgressMonitor fMonitor;

    public UploadRuleAction(ILaunchConfiguration configuration, UploadRule uploadRule, IProgressMonitor monitor) {
        this.fRule = uploadRule;
        this.fConfiguration = configuration;
        this.fMonitor = monitor;
    }

    @Override
    public void run() throws CoreException {
        Assert.isNotNull((Object)this.fRule);
        Assert.isNotNull((Object)this.fConfiguration);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)this.fMonitor, (int)40);
        String execPath = this.fConfiguration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
        IPath defaultRemotePath = new Path(execPath).removeLastSegments(1);
        IPath remotePathParent = null;
        if (this.fRule.isDefaultRemoteDirectory()) {
            remotePathParent = defaultRemotePath;
        } else {
            remotePathParent = new Path(this.fRule.getRemoteDirectory());
            if (!remotePathParent.isAbsolute()) {
                remotePathParent = defaultRemotePath.append(remotePathParent);
            }
        }
        remotePathParent = remotePathParent.removeTrailingSeparator();
        Assert.isTrue((boolean)remotePathParent.isAbsolute(), (String)"remotePathWoLastSegment.isAbsolute()");
        IPath workingDir = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IPath[] localPaths = this.fRule.getLocalFilesAsPathArray();
        int i = 0;
        while (i < localPaths.length) {
            IPath localPath = localPaths[i];
            if (!localPath.isAbsolute()) {
                localPath = workingDir.append(localPath);
            }
            localPath = localPath.removeTrailingSeparator();
            Assert.isTrue((boolean)localPath.isAbsolute(), (String)"localPath.isAbsolute()");
            localPaths[i] = localPath;
            ++i;
        }
        IPath[] iPathArray = localPaths;
        int n = localPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath localPath = iPathArray[n2];
            progress.setWorkRemaining(100);
            IRemoteFileService localFileManager = RMLaunchUtils.getLocalFileService(this.fConfiguration);
            IFileStore localFileStore = localFileManager.getResource(localPath.toString());
            IFileInfo localFileInfo = localFileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            if (localFileInfo.exists()) {
                IPath remotePath = remotePathParent.append(localPath.lastSegment());
                IRemoteFileService remoteFileManager = RMLaunchUtils.getRemoteFileService(this.fConfiguration, (IProgressMonitor)progress.newChild(5));
                IFileStore remoteFileStore = remoteFileManager.getResource(remotePath.toString());
                IFileStore parentFileStore = remoteFileManager.getResource(remotePathParent.toString());
                parentFileStore.mkdir(0, (IProgressMonitor)progress.newChild(5));
                this.doUpload(localFileStore, localPath, remoteFileStore, remotePath, (IProgressMonitor)progress.newChild(25));
            }
            ++n2;
        }
    }

    private void doUpload(IFileStore localFileStore, IPath localPath, IFileStore remoteFileStore, IPath remotePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IFileInfo remoteFileInfo = remoteFileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            IFileInfo localFileInfo = localFileStore.fetchInfo();
            if (remoteFileInfo.exists()) {
                switch (this.fRule.getOverwritePolicy()) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        long dupFileModTime = remoteFileInfo.getLastModified();
                        long localFileModTime = localFileInfo.getLastModified();
                        if (dupFileModTime < localFileModTime) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            localFileStore.copy(remoteFileStore, 2, (IProgressMonitor)progress.newChild(5));
            if (this.fRule.isDownloadBack()) {
                if (this.fDownloadBackRule == null) {
                    this.fDownloadBackRule = new DownloadBackRule();
                }
                this.fDownloadBackRule.add(localPath.toFile(), remotePath);
            }
            boolean changedAttr = false;
            if (this.fRule.isAsReadOnly()) {
                remoteFileInfo.setAttribute(2, true);
                changedAttr = true;
            }
            if (this.fRule.isAsExecutable()) {
                remoteFileInfo.setAttribute(4, true);
                changedAttr = true;
            }
            if (changedAttr) {
                remoteFileStore.putInfo(remoteFileInfo, 1024, (IProgressMonitor)progress.newChild(5));
            }
            if (this.fRule.isPreserveTimeStamp()) {
                remoteFileInfo.setLastModified(localFileInfo.getLastModified());
                remoteFileStore.putInfo(remoteFileInfo, 2048, (IProgressMonitor)progress.newChild(5));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

