/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class SignalActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IPSignal fSignal = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getSignal() != null) {
            final MultiStatus ms = new MultiStatus(PTPDebugUIPlugin.getUniqueIdentifier(), 5012, "Unable to deliver the signal to the target.", null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SignalActionDelegate.this.doAction(SignalActionDelegate.this.getSignal());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = PTPDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    PTPDebugUIPlugin.errorDialog("Operation failed.", (IStatus)ms);
                } else {
                    PTPDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPSignal) {
            boolean enabled = this.enablesFor((IPSignal)element);
            action.setEnabled(enabled);
            if (enabled) {
                this.setSignal((IPSignal)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setSignal(null);
    }

    protected void doAction(IPSignal signal) throws DebugException {
        signal.signal();
    }

    private boolean enablesFor(IPSignal signal) {
        return signal != null && signal.getDebugTarget().isSuspended();
    }

    private void setSignal(IPSignal signal) {
        this.fSignal = signal;
    }

    protected IPSignal getSignal() {
        return this.fSignal;
    }
}

