/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.generator.egf.xwt;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.emf.EMFDomainHelper;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.pattern.DomainVisitor;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.ftask.tasks.DomainDrivenStrategyTask;
import org.eclipse.egf.pattern.strategy.AbstractStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.pmf.generator.egf.xwt.i18n.ExternalStrings;
import org.eclipse.pmf.pim.transformation.CodeGenContext;

public class PMFCodegenStrategyTask
extends DomainDrivenStrategyTask {
    public static final String CODEGEN_CONTEXT = "codegen.context";
    private PatternContext writedCtx;

    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.readContext(context, ctx);
        EMFDomain value = (EMFDomain)context.getInputValue((Object)CODEGEN_CONTEXT, EMFDomain.class);
        if (value != null) {
            Object object;
            if (!value.isLoaded() && value.getUri() != null) {
                try {
                    new EMFDomainHelper().loadDomain((Domain)value);
                }
                catch (DomainException domainException) {
                    // empty catch block
                }
            }
            if (!value.getContent().isEmpty() && (object = value.getContent().get(0)) instanceof CodeGenContext) {
                ctx.setValue(CODEGEN_CONTEXT, object);
            }
        }
        if (!(ctx.getValue(CODEGEN_CONTEXT) instanceof CodeGenContext)) {
            ctx.setValue(CODEGEN_CONTEXT, null);
        }
    }

    protected void writeContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.writeContext(context, ctx);
        this.writedCtx = ctx;
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        this.externalStrings();
        super.postExecute(context, monitor);
    }

    private void externalStrings() throws InvocationException {
        try {
            Strategy strategy = new Strategy();
            strategy.setPatternElements(this.patterns);
            strategy.execute(this.writedCtx, Collections.singletonList(ExternalStrings.INSTANCE));
        }
        catch (PatternException e) {
            throw new InvocationException((Throwable)e);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    private static class Strategy
    extends AbstractStrategy {
        private Strategy() {
        }

        public void execute(PatternContext context, Object parameter) throws PatternException, ExtensionHelper.MissingExtensionException {
            ArrayList result = new ArrayList(100);
            PatternCollector.INSTANCE.collect((EObject[])this.patternElements, result);
            DomainVisitor visitor = (DomainVisitor)context.getValue("pattern.domain.driven.visitor");
            visitor.setPatterns(result);
            try {
                visitor.visit(context, parameter);
            }
            finally {
                visitor.dispose();
            }
        }
    }
}

