/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.projectoutlineview.OutlineUtils;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineGroups;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkingSet;

public class ProjectOutlineContentProvider
extends ScriptExplorerContentProvider
implements ITreeContentProvider,
IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    static IScriptProject scripProject = null;
    private Collection fPendingUpdates = null;

    public ProjectOutlineContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        ArrayList runnables = new ArrayList();
        try {
            if (this.inputDeleted(runnables)) {
                return;
            }
            try {
                this.processDelta(event.getDelta(), runnables);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
        }
        finally {
            this.executeProjOutlineRunnables(runnables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeProjOutlineRunnables(Collection runnables) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                this.runUpdates(runnables);
            } else {
                ProjectOutlineContentProvider projectOutlineContentProvider = this;
                synchronized (projectOutlineContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = runnables;
                    } else {
                        this.fPendingUpdates.addAll(runnables);
                    }
                }
                ctrl.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProjectOutlineContentProvider.this.runPendingUpdates();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Control control;
        Collection pendingUpdates;
        ProjectOutlineContentProvider projectOutlineContentProvider = this;
        synchronized (projectOutlineContentProvider) {
            pendingUpdates = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (pendingUpdates != null && this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(pendingUpdates);
        }
    }

    private void runUpdates(Collection runnables) {
        Iterator runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    private boolean inputDeleted(Collection runnables) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IModelElement && ((IModelElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, runnables);
        return true;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IScriptProject) {
            scripProject = (IScriptProject)element;
            return ProjectOutlineGroups.values();
        }
        if (element instanceof ProjectOutlineGroups) {
            return ((ProjectOutlineGroups)((Object)element)).getChildren();
        }
        return super.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProjectOutlineGroups) {
            return true;
        }
        return super.hasChildren(element);
    }

    protected Object internalGetParentGroupNode(Object element) {
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            if (OutlineUtils.isGlobalClass(modelElement)) {
                return ProjectOutlineGroups.GROUP_CLASSES;
            }
            if (OutlineUtils.isGlobalFunction(modelElement)) {
                return ProjectOutlineGroups.GROUP_FUNCTIONS;
            }
            if (OutlineUtils.isConstant(modelElement)) {
                return ProjectOutlineGroups.GROUP_CONSTANTS;
            }
            return ProjectOutlineGroups.GROUP_NAMESPACES;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (newInput != null && newInput instanceof Model) {
            try {
                IScriptProject[] scriptProjects = ((Model)newInput).getScriptProjects();
                newInput = scriptProjects.length > 0 ? scriptProjects[0] : new IScriptProject[]{};
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        this.fViewer = (TreeViewer)viewer;
        if (this.fInput == null || !this.fInput.equals(newInput)) {
            this.fInput = newInput;
        }
    }

    private boolean processDelta(IModelElementDelta delta, final Collection runnables) throws ModelException {
        int kind = delta.getKind();
        IModelElement element = delta.getElement();
        Object parent = this.internalGetParentGroupNode(element);
        if (kind == 1) {
            IScriptProject refreshRoot;
            Object object = refreshRoot = element instanceof IOpenable ? element.getScriptProject() : element.getParent();
            if (parent == null) {
                this.postRefresh(refreshRoot, 0, element, runnables);
                return false;
            }
            this.postAdd(parent, element, runnables);
        } else if (kind == 2) {
            if (element instanceof IOpenable) {
                final IPath removedPath = element.getPath();
                this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeItem[] treeItemArray = ProjectOutlineContentProvider.this.fViewer.getTree().getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem[] treeItems;
                            TreeItem node = treeItemArray[n2];
                            TreeItem[] treeItemArray2 = treeItems = node.getItems();
                            int n3 = treeItems.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                TreeItem treeItem = treeItemArray2[n4];
                                IModelElement itemData = (IModelElement)treeItem.getData();
                                if (itemData != null && removedPath.isPrefixOf(itemData.getPath())) {
                                    ProjectOutlineContentProvider.this.postRemove((IModelElement)treeItem.getData(), runnables);
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                });
            } else {
                this.postRemove(element, runnables);
            }
            return false;
        }
        this.handleAffectedChildren(delta, element, runnables);
        return false;
    }

    void handleAffectedChildren(IModelElementDelta delta, IModelElement element, Collection runnables) throws ModelException {
        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (affectedChildren.length > 1) {
            int count = 0;
            int i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getElement() instanceof IOpenable) {
                    ++count;
                }
                if (count > 1) {
                    this.postRefresh(this.fInput, 0, element, runnables);
                    return;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < affectedChildren.length) {
            if (this.processDelta(affectedChildren[i], runnables)) {
                return;
            }
            ++i;
        }
    }
}

