/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.refactoring.core.extract.variable.ExtractVariableRefactoring;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.php.refactoring.ui.utils.RefactoringStarter;
import org.eclipse.php.refactoring.ui.wizard.ExtractVariableWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ExtractVariableActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart targetEditor;
    private Shell shell;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        this.targetEditor = targetEditor;
        IWorkbenchPartSite site = targetEditor.getSite();
        if (site != null) {
            this.shell = site.getShell();
        }
    }

    public void run(IAction action) {
        if (this.targetEditor == null) {
            this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (!(this.targetEditor instanceof PHPStructuredEditor)) {
            return;
        }
        PHPStructuredEditor phpEditor = (PHPStructuredEditor)this.targetEditor;
        IFile file = ((IFileEditorInput)phpEditor.getEditorInput()).getFile();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForEdit(file);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            IModelElement source = phpEditor.getModelElement();
            if (!(source instanceof ISourceModule)) {
                MessageDialog.openError((Shell)this.shell, (String)"Error", (String)"Unexpected Error");
                return;
            }
            ITextSelection fTextSelection = (ITextSelection)phpEditor.getSelectionProvider().getSelection();
            int startOffset = fTextSelection.getOffset();
            int length = fTextSelection.getLength();
            try {
                ExtractVariableRefactoring refactoring = new ExtractVariableRefactoring((ISourceModule)source, (IDocument)structuredDocument, startOffset, length);
                new RefactoringStarter().activate((Refactoring)refactoring, new ExtractVariableWizard(refactoring), this.shell, PHPRefactoringUIMessages.getString("ExtractVariableActionDelegate.0"), false);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)this.shell, (String)"Error", (String)e.getMessage());
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            this.targetEditor = null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public int tst() {
        return 0;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

