/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.util.MagicMemberUtil;

public class PHPEvaluationUtils {
    public static final String BRACKETS = "[]";
    public static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]", 2);
    private static final String SELF_RETURN_TYPE = "self";
    private static final String STATIC_RETURN_TYPE = "static";
    private static final String THIS_RETURN_TYPE = "$this";
    public static final String BRACKETS_REGEX = "\\[.*\\]";
    public static final Pattern TYPE_DELIMS_PATTERN = Pattern.compile("([,\\[\\]]+)");
    private static final IEvaluatedType[] EMPTY_LIST = new IEvaluatedType[0];

    public static String extractArrayType(String typeName) {
        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
        if (m.find()) {
            int beginIndex = typeName.indexOf(91) + 1;
            int endIndex = typeName.lastIndexOf(93);
            if (endIndex != -1) {
                return typeName.substring(beginIndex, endIndex);
            }
        }
        return PHPEvaluationUtils.removeArrayBrackets(typeName);
    }

    public static boolean isArrayType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
        return m.find() || typeName.endsWith(BRACKETS) && typeName.length() > 2;
    }

    public static IEvaluatedType extractArrayType(String typeName, IType currentNamespace, int offset) {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
        if (m.find()) {
            return PHPEvaluationUtils.getArrayType(m.group(), currentNamespace, offset);
        }
        if (typeName.endsWith(BRACKETS) && typeName.length() > 2) {
            return PHPEvaluationUtils.getArrayType(typeName.substring(0, typeName.length() - 2), currentNamespace, offset);
        }
        return null;
    }

    public static MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf(91) + 1;
        int endIndex = type.lastIndexOf(93);
        if (endIndex != -1) {
            type = type.substring(beginIndex, endIndex);
        }
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)PHPEvaluationUtils.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        } else if (type.endsWith(BRACKETS) && type.length() > 2) {
            arrayType.addType((IEvaluatedType)PHPEvaluationUtils.getArrayType(type.substring(0, type.length() - 2), currentNamespace, offset));
            type = type.replaceAll(Pattern.quote(BRACKETS), "");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                int nsSeparatorIndex = name.indexOf(92);
                if (currentNamespace != null && (nsSeparatorIndex < 0 || nsSeparatorIndex > 0)) {
                    String fullName;
                    Map<String, UsePart> result;
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name;
                    if (nsSeparatorIndex > 0) {
                        prefix = name.substring(0, nsSeparatorIndex);
                    }
                    if ((result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true)).containsKey(prefix) && (name = name.replace(prefix, fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                        name = String.valueOf('\\') + name;
                    }
                }
                arrayType.addType(PHPEvaluationUtils.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    public static Collection<String> getTypeBinding(String name, PHPDocTag docTag) {
        String[] split = MagicMemberUtil.WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
        if (split.length < 2) {
            return Collections.emptyList();
        }
        if (split[1].equals(name)) {
            if (STATIC_RETURN_TYPE.equals(split[0])) {
                return Collections.emptyList();
            }
            return Arrays.asList(split[0].split("\\|"));
        }
        if (STATIC_RETURN_TYPE.equals(split[0]) && (split = Arrays.copyOfRange(split, 1, split.length)).length < 2) {
            return Collections.emptyList();
        }
        String substring = split[1];
        int parenIndex = split[1].indexOf(40);
        if (parenIndex != -1) {
            substring = substring.substring(0, parenIndex);
        }
        if (substring.equals(name)) {
            return Arrays.asList(split[0].split("\\|"));
        }
        return Collections.emptyList();
    }

    public static IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        if (typeName.indexOf(92) > 0 && currentNamespace != null) {
            typeName = String.valueOf('\\') + currentNamespace.getElementName() + '\\' + typeName;
        }
        if (typeName.indexOf(92) != -1 || currentNamespace == null) {
            return new PHPClassType(typeName);
        }
        return new PHPClassType(currentNamespace.getElementName(), typeName);
    }

    public static String removeArrayBrackets(String variableName) {
        return variableName.replaceAll(BRACKETS_REGEX, "");
    }

    public static IEvaluatedType[] evaluatePHPDocType(String[] typeNames, IModelElement space, int offset, IType[] types) {
        ISourceModule sourceModule = (ISourceModule)space.getAncestor(ISourceModule.class);
        IType currentNamespace = space instanceof IType ? (IType)space : null;
        LinkedList res = new LinkedList();
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String typeName = stringArray[n2];
            LinkedList<Object> evaluated = new LinkedList<Object>();
            if (!StringUtils.isBlank((CharSequence)typeName)) {
                IEvaluatedType evaluatedType = PHPEvaluationUtils.extractArrayType(typeName, currentNamespace, offset);
                if (evaluatedType != null) {
                    evaluated.add(evaluatedType);
                } else if (PHPSimpleTypes.isSimpleType(typeName)) {
                    ClassFinder classFinder = new ClassFinder(typeName);
                    try {
                        space.accept((IModelElementVisitor)classFinder);
                    }
                    catch (ModelException e) {
                        Logger.logException(e);
                    }
                    if (classFinder.found) {
                        evaluated.add(PHPEvaluationUtils.getEvaluatedType(typeName, currentNamespace));
                    } else {
                        evaluated.add(PHPSimpleTypes.fromString(typeName));
                    }
                } else if ((typeName.equals(SELF_RETURN_TYPE) || typeName.equals(THIS_RETURN_TYPE) || typeName.equals(STATIC_RETURN_TYPE)) && types != null) {
                    IType[] iTypeArray = types;
                    int n3 = types.length;
                    int e = 0;
                    while (e < n3) {
                        IType t = iTypeArray[e];
                        IEvaluatedType type = PHPEvaluationUtils.getEvaluatedType(PHPModelUtils.getFullName(t), null);
                        if (type != null) {
                            evaluated.add(type);
                        }
                        ++e;
                    }
                } else if (typeName.indexOf(92) == 0) {
                    evaluated.add((Object)new PHPClassType(typeName));
                } else {
                    IEvaluatedType type;
                    if (currentNamespace != null) {
                        Map<String, UsePart> result;
                        String fullName;
                        String prefix;
                        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                        if (typeName.indexOf(92) > 0) {
                            prefix = typeName.substring(0, typeName.indexOf(92));
                            Map<String, UsePart> result2 = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true);
                            if (result2.containsKey(prefix) && (typeName = typeName.replace(prefix, fullName = result2.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                                typeName = String.valueOf('\\') + typeName;
                            }
                        } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, offset, currentNamespace, true)).containsKey(prefix) && (typeName = (fullName = result.get(prefix).getNamespace().getFullyQualifiedName())).charAt(0) != '\\') {
                            typeName = String.valueOf('\\') + typeName;
                        }
                    }
                    if ((type = PHPEvaluationUtils.getEvaluatedType(typeName, currentNamespace)) != null) {
                        evaluated.add(type);
                    }
                }
                res.addAll(evaluated);
            }
            ++n2;
        }
        if (res.isEmpty()) {
            return EMPTY_LIST;
        }
        return res.toArray(new IEvaluatedType[res.size()]);
    }

    public static IEvaluatedType[] evaluatePHPDocType(List<TypeReference> typeNames, IModelElement space, int offset, IType[] types) {
        if (typeNames == null || typeNames.isEmpty()) {
            return EMPTY_LIST;
        }
        String[] tmp = new String[typeNames.size()];
        int i = 0;
        while (i < typeNames.size()) {
            tmp[i] = typeNames.get(i).getName();
            ++i;
        }
        return PHPEvaluationUtils.evaluatePHPDocType(tmp, space, offset, types);
    }

    private static class ClassFinder
    implements IModelElementVisitor {
        private final String search;
        public boolean found = false;

        public ClassFinder(String name) {
            this.search = name;
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 7 && this.search.equals(element.getElementName())) {
                this.found = true;
            }
            return !this.found;
        }
    }
}

