/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class ConstantsOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ConstantsOccurrencesFinder";
    private boolean defineFound;
    private boolean isCaseSensitiveConstant = true;
    private String constantName;
    private ASTNode nameNode;
    private Map<ASTNode, String> nodeToFullName = new HashMap<ASTNode, String>();
    private Map<ASTNode, IOccurrencesFinder.OccurrenceLocation> nodeToOccurrence = new HashMap<ASTNode, IOccurrencesFinder.OccurrenceLocation>();

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.defineFound = false;
        this.isCaseSensitiveConstant = true;
        if (node.getType() == 51) {
            this.nameNode = (Scalar)node;
            this.constantName = ((Scalar)this.nameNode).getStringValue();
            if (ConstantsOccurrencesFinder.isQuoted(this.constantName)) {
                this.constantName = this.constantName.substring(1, this.constantName.length() - 1);
            }
            return null;
        }
        if (node.getType() == 33 && node.getParent().getType() == 65) {
            this.nameNode = node;
            this.constantName = ((Identifier)node).getName();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, this.constantName);
        this.fASTRoot.accept(this);
        if (this.nodeToFullName.containsKey(this.nameNode)) {
            String fullName = this.nodeToFullName.get(this.nameNode);
            for (ASTNode nameNode : this.nodeToFullName.keySet()) {
                if (!this.nodeToFullName.get(nameNode).equalsIgnoreCase(fullName)) continue;
                this.fResult.add(this.nodeToOccurrence.get(nameNode));
            }
        }
    }

    @Override
    public boolean visit(Identifier identifier) {
        if (this.checkEquality(identifier.getName()) && PHPElementConciliator.isGlobalConstant(identifier)) {
            this.nodeToFullName.put(identifier, ConstantsOccurrencesFinder.getFullName((Identifier)identifier.getParent(), (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace));
            this.nodeToOccurrence.put(identifier, new IOccurrencesFinder.OccurrenceLocation(identifier.getStart(), identifier.getLength(), this.getOccurrenceType(identifier), this.fDescription));
        }
        return true;
    }

    @Override
    public boolean visit(Scalar scalar) {
        String scalarValue = scalar.getStringValue();
        if (scalar.getScalarType() == 2 && scalarValue != null) {
            if (!ConstantsOccurrencesFinder.isQuoted(scalarValue) && scalar.getParent().getType() != 47) {
                if (this.checkEquality(scalarValue)) {
                    this.nodeToFullName.put(scalar, ConstantsOccurrencesFinder.getFullName(scalarValue, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace));
                    this.nodeToOccurrence.put(scalar, new IOccurrencesFinder.OccurrenceLocation(scalar.getStart(), scalar.getLength(), this.getOccurrenceType(scalar), this.fDescription));
                }
            } else {
                FunctionInvocation functionInvocation;
                Expression name;
                ASTNode parent;
                if (ConstantsOccurrencesFinder.isQuoted(scalarValue)) {
                    scalarValue = scalarValue.substring(1, scalarValue.length() - 1);
                }
                if (this.checkEquality(scalarValue) && (parent = scalar.getParent()).getType() == 30 && (name = (functionInvocation = (FunctionInvocation)parent).getFunctionName().getName()) instanceof Identifier) {
                    String functionName = ((Identifier)name).getName();
                    if ("define".equalsIgnoreCase(functionName)) {
                        this.defineFound = true;
                        this.isCaseSensitiveConstant = this.isCaseSensitiveDefined(functionInvocation.parameters());
                        if (!this.isCaseSensitiveConstant || this.isCaseSensitiveConstant && this.constantName.equals(scalarValue)) {
                            String writeDescription = Messages.format(BASE_WRITE_DESCRIPTION, scalar.getStringValue());
                            this.nodeToFullName.put(scalar, ConstantsOccurrencesFinder.getFullName(scalarValue, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace));
                            this.nodeToOccurrence.put(scalar, new IOccurrencesFinder.OccurrenceLocation(scalar.getStart(), scalar.getLength(), 1, writeDescription));
                        }
                    } else if ("constant".equalsIgnoreCase(functionName) && (!this.isCaseSensitiveConstant || this.isCaseSensitiveConstant && this.constantName.equals(scalarValue))) {
                        this.nodeToFullName.put(scalar, ConstantsOccurrencesFinder.getFullName(scalarValue, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace));
                        this.nodeToOccurrence.put(scalar, new IOccurrencesFinder.OccurrenceLocation(scalar.getStart(), scalar.getLength(), 2, this.fDescription));
                    }
                }
            }
        }
        return true;
    }

    private boolean isCaseSensitiveDefined(List<Expression> parameters) {
        if (parameters.size() != 3) {
            return true;
        }
        Expression expression = parameters.get(2);
        if (expression.getType() == 51) {
            Scalar scalar = (Scalar)expression;
            String value = scalar.getStringValue();
            return "true".equalsIgnoreCase(value);
        }
        return false;
    }

    private boolean checkEquality(String scalarValue) {
        if (!this.isCaseSensitiveConstant || !this.defineFound) {
            return this.constantName.equalsIgnoreCase(scalarValue);
        }
        return this.constantName.equals(scalarValue);
    }

    private static boolean isQuoted(String str) {
        if (str == null || str.length() < 3) {
            return false;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        return !(first != '\'' && first != '\"' || last != '\'' && last != '\"');
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    @Override
    public String getElementName() {
        return this.constantName;
    }

    @Override
    public String getID() {
        return ID;
    }
}

