/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.IFormatterCommonPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class FormatterUtils {
    private static final String FORMATTER_COMMON_PREFERENCE_EXT = "org.eclipse.php.core.phpFormatterCommonPreferences";
    private static PHPStructuredTextPartitioner partitioner = new PHPStructuredTextPartitioner();
    private static IFormatterCommonPreferences usedFormatter;
    public static final String PARTITION_CSS_STYLE = "org.eclipse.wst.css.STYLE";
    public static final String PARTITION_JS_SCRIPT = "org.eclipse.wst.html.SCRIPT";
    private static StringBuilder helpBuffer;

    static {
        helpBuffer = new StringBuilder(50);
    }

    @Nullable
    public static String getRegionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion;
        block8: {
            try {
                sdRegion = document.getRegionAtCharacterOffset(offset);
                if (sdRegion != null) break block8;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        if (tRegion != null && tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        if (tRegion != null) {
            int regionStart = sdRegion.getStartOffset(tRegion);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion != null && tRegion instanceof IPHPScriptRegion) {
                IPHPScriptRegion scriptRegion = (IPHPScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getPHPToken(regionOffset);
                return innerRegion.getType();
            }
        }
        return null;
    }

    @Nullable
    public static String getPartitionType(IStructuredDocument document, int offset, boolean preferNonWhitespacePartitions) {
        IStructuredDocumentRegion sdRegion;
        block8: {
            try {
                sdRegion = document.getRegionAtCharacterOffset(offset);
                if (sdRegion != null) break block8;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        if (tRegion != null && tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion != null && tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion != null && tRegion instanceof IPHPScriptRegion) {
            IPHPScriptRegion scriptRegion = (IPHPScriptRegion)tRegion;
            if (preferNonWhitespacePartitions && scriptRegion.getPHPToken(offset - regionStart).getTextEnd() <= offset - regionStart) {
                return scriptRegion.getPartition(scriptRegion.getPHPToken(offset - regionStart).getEnd());
            }
            return scriptRegion.getPartition(offset - regionStart);
        }
        partitioner.connect((IDocument)document);
        return partitioner.getContentType(offset);
    }

    @Nullable
    public static String getPartitionType(IStructuredDocument document, int offset) {
        return FormatterUtils.getPartitionType(document, offset, false);
    }

    public static String getLineBlanks(IDocument document, IRegion lineInfo) throws BadLocationException {
        helpBuffer.setLength(0);
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        char[] line = document.get(startOffset, length).toCharArray();
        int i = 0;
        while (i < length) {
            char c = line[i];
            if (!Character.isWhitespace(c)) break;
            helpBuffer.append(c);
            ++i;
        }
        return helpBuffer.toString();
    }

    public static IStructuredDocumentRegion getLastPHPStructuredDocumentRegion(IStructuredDocumentRegion currentStructuredDocumentRegion) {
        assert (currentStructuredDocumentRegion != null);
        currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        while (currentStructuredDocumentRegion != null && currentStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        }
        return currentStructuredDocumentRegion;
    }

    public static IFormatterCommonPreferences getFormatterCommonPreferences() {
        if (usedFormatter == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(FORMATTER_COMMON_PREFERENCE_EXT);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals("processor")) {
                    try {
                        usedFormatter = (IFormatterCommonPreferences)element.createExecutableExtension("class");
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
            if (usedFormatter == null) {
                usedFormatter = FormatPreferencesSupport.getInstance();
            }
        }
        return usedFormatter;
    }
}

