/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.ui.controller.PsrController;
import org.eclipse.php.composer.ui.dialogs.PsrDialog;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.TreeSection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.TreePart;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ResourceTransfer;

public abstract class PsrSection
extends TreeSection
implements PropertyChangeListener {
    protected TreeViewer psrViewer;
    private IAction addAction;
    private IAction editAction;
    private IAction removeAction;
    private static final int ADD_INDEX = 0;
    private static final int EDIT_INDEX = 1;
    private static final int REMOVE_INDEX = 2;
    protected Psr psr = this.getPsr();

    public PsrSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{Messages.PsrSection_AddButton, Messages.PsrSection_EditButton, Messages.PsrSection_RemoveButton});
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    protected abstract Psr getPsr();

    protected abstract String getPsrName();

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        String name = this.getPsrName();
        section.setText(name);
        section.setDescription(NLS.bind((String)Messages.PsrSection_Description, (Object)name));
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 4, 2, toolkit);
        TreePart treePart = this.getTreePart();
        PsrController controller = new PsrController(treePart.getTreeViewer());
        this.psrViewer = treePart.getTreeViewer();
        this.psrViewer.setContentProvider((IContentProvider)controller);
        this.psrViewer.setLabelProvider((IBaseLabelProvider)controller);
        Transfer[] transferTypes = new Transfer[]{ResourceTransfer.getInstance()};
        int types = 23;
        this.psrViewer.addDropSupport(types, transferTypes, (DropTargetListener)new PathDropAdapter((Viewer)this.psrViewer));
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        this.psrViewer.setInput((Object)this.psr);
        this.composerPackage.getAutoload().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateButtons();
        this.makeActions();
        this.updateMenu();
    }

    private void updateButtons() {
        ISelection selection = this.psrViewer.getSelection();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, this.enabled);
        treePart.setButtonEnabled(1, !selection.isEmpty() && this.enabled);
        treePart.setButtonEnabled(2, !selection.isEmpty() && this.enabled);
    }

    private void updateMenu() {
        IStructuredSelection selection = (IStructuredSelection)this.psrViewer.getSelection();
        this.editAction.setEnabled(selection.size() > 0);
        this.removeAction.setEnabled(selection.size() > 0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.refresh();
        this.psrViewer.getTree().setEnabled(enabled);
    }

    public void refresh() {
        this.psrViewer.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().startsWith(this.getPsrName())) {
            this.refresh();
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.updateButtons();
        this.updateMenu();
    }

    private void makeActions() {
        this.addAction = new Action(Messages.PsrSection_AddActionTitle){

            public void run() {
                PsrSection.this.handleAdd();
            }
        };
        this.editAction = new Action(Messages.PsrSection_EditActionTitle){

            public void run() {
                PsrSection.this.handleEdit();
            }
        };
        this.removeAction = new Action(Messages.PsrSection_RemoveActionTitle){

            public void run() {
                PsrSection.this.handleRemove();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(this.addAction);
        manager.add(this.editAction);
        manager.add(this.removeAction);
    }

    private void handleAdd() {
        PsrDialog dialog = new PsrDialog(this.psrViewer.getTree().getShell(), new Namespace(), this.getPage().getComposerEditor().getProject());
        if (dialog.open() == 0) {
            this.psr.add(dialog.getNamespace());
        }
    }

    private void handleEdit() {
        PsrDialog diag;
        Namespace namespace = null;
        Object element = ((StructuredSelection)this.psrViewer.getSelection()).getFirstElement();
        if (element instanceof String) {
            element = ((PsrController)this.psrViewer.getContentProvider()).getParent(element);
        }
        if (element instanceof Namespace) {
            namespace = (Namespace)element;
        }
        if (namespace != null && (diag = new PsrDialog(this.psrViewer.getTree().getShell(), namespace.clone(), this.getPage().getComposerEditor().getProject())).open() == 0) {
            Namespace nmspc = (Namespace)this.psr.get(namespace.getNamespace());
            if (nmspc.equals((Object)diag.getNamespace())) {
                return;
            }
            if (!nmspc.getNamespace().equals(diag.getNamespace().getNamespace())) {
                this.psr.remove(nmspc);
                this.psr.add(diag.getNamespace());
            } else {
                nmspc.clear();
                nmspc.addPaths(diag.getNamespace().getPaths());
            }
        }
    }

    private void handleRemove() {
        Namespace namespace;
        Object element = ((StructuredSelection)this.psrViewer.getSelection()).getFirstElement();
        if (element instanceof Namespace) {
            this.psr.remove((Namespace)element);
        } else if (element instanceof String && (namespace = (Namespace)((PsrController)this.psrViewer.getContentProvider()).getParent(element)) != null) {
            namespace.remove((String)element);
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
    }

    private class PathDropAdapter
    extends ViewerDropAdapter {
        private Namespace target;

        public PathDropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object data) {
            if (data instanceof IResource[]) {
                IResource[] resources = (IResource[])data;
                ArrayList<IFolder> folders = new ArrayList<IFolder>();
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IFolder) {
                        folders.add((IFolder)resource);
                    }
                    ++n2;
                }
                for (IFolder folder : folders) {
                    this.target.add(folder.getProjectRelativePath().toString());
                }
                return false;
            }
            return false;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (target instanceof Namespace) {
                this.target = (Namespace)target;
                return true;
            }
            return false;
        }
    }
}

