/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.collection.Dependencies;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.composer.ComposerFormEditor;
import org.eclipse.php.composer.ui.editor.composer.DependencySearchSection;
import org.eclipse.php.composer.ui.editor.composer.DependencySection;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.composer.DependencySelectionFinishedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DependenciesPage
extends ComposerFormPage {
    public static final String ID = "org.eclipse.php.composer.ui.editor.composer.DependencyPage";
    private ComposerPackage composerPackage;
    protected ComposerFormEditor editor;
    protected Composite left;
    protected Composite right;
    protected DependencySection activeSection;
    protected DependencySection requireSection = null;
    protected TableViewer requireView;
    protected Button requireEdit;
    protected Button requireRemove;
    protected DependencySection requireDevSection;
    protected TableViewer requireDevView;
    protected Button requireDevEdit;
    protected Button requireDevRemove;
    protected DependencySearchSection searchSection;

    public DependenciesPage(ComposerFormEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
        this.editor = editor;
        this.composerPackage = editor.getComposerPackge();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.editor.getHeaderForm().getForm().setText(Messages.DependenciesPage_Title);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormGridLayout(true, 2));
        this.left = toolkit.createComposite(form.getBody(), 0);
        this.left.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout(false, 1));
        this.left.setLayoutData((Object)new GridData(1808));
        this.requireSection = new DependencySection(this, this.left, this.composerPackage.getRequire(), Messages.DependenciesPage_RequireSectionTitle, Messages.DependenciesPage_RequireSectionDescription, true);
        this.requireDevSection = new DependencySection(this, this.left, this.composerPackage.getRequireDev(), Messages.DependenciesPage_RequireDevSectionTitle, Messages.DependenciesPage_RequireDevSectionDescription, false);
        this.requireSection.setEnabled(this.enabled);
        this.requireSection.getSection().addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                DependenciesPage.this.activeSection = e.getState() ? DependenciesPage.this.requireSection : DependenciesPage.this.requireDevSection;
                DependenciesPage.this.requireDevSection.getSection().setExpanded(!e.getState());
                ((GridData)DependenciesPage.this.requireSection.getSection().getLayoutData()).grabExcessVerticalSpace = e.getState();
                ((GridData)DependenciesPage.this.requireDevSection.getSection().getLayoutData()).grabExcessVerticalSpace = !e.getState();
            }
        });
        this.requireDevSection.setEnabled(this.enabled);
        this.requireDevSection.getSection().addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                DependenciesPage.this.activeSection = e.getState() ? DependenciesPage.this.requireDevSection : DependenciesPage.this.requireSection;
                DependenciesPage.this.requireSection.getSection().setExpanded(!e.getState());
                ((GridData)DependenciesPage.this.requireDevSection.getSection().getLayoutData()).grabExcessVerticalSpace = e.getState();
                ((GridData)DependenciesPage.this.requireSection.getSection().getLayoutData()).grabExcessVerticalSpace = !e.getState();
            }
        });
        this.activeSection = this.requireSection;
        this.right = toolkit.createComposite(form.getBody(), 0);
        this.right.setLayout((Layout)FormLayoutFactory.createFormPaneGridLayout(false, 1));
        this.right.setLayoutData((Object)new GridData(1808));
        this.searchSection = new DependencySearchSection(this, this.right);
        this.searchSection.setEnabled(this.enabled);
        this.searchSection.addDependencySelectionFinishedListener(new DependencySelectionFinishedListener(){

            @Override
            public void dependenciesSelected(Dependencies dependencies) {
                Dependencies deps = DependenciesPage.this.activeSection == DependenciesPage.this.requireSection ? DependenciesPage.this.composerPackage.getRequire() : DependenciesPage.this.composerPackage.getRequireDev();
                deps.addAll(dependencies);
                DependenciesPage.this.activeSection.setFocus();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.requireSection != null) {
            this.requireSection.setEnabled(enabled);
            this.requireDevSection.setEnabled(enabled);
            this.searchSection.setEnabled(enabled);
        }
    }
}

