/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ImplicitSpec;
import org.eclipse.photran.internal.core.analysis.binding.VariableAccess;
import org.eclipse.photran.internal.core.analysis.types.ArraySpec;
import org.eclipse.photran.internal.core.analysis.types.Dimension;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.Messages;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;

public class PhotranVPGSerializer {
    public static final byte CLASS_NULL = 48;
    public static final byte CLASS_STRING = 115;
    public static final byte CLASS_INT = 105;
    public static final byte CLASS_BOOLEAN = 98;
    public static final byte CLASS_TOKENREF = 84;
    public static final byte CLASS_DEFINITION = 68;
    public static final byte CLASS_TYPE = 89;
    public static final byte CLASS_ARRAYSPEC = 65;
    public static final byte CLASS_DIMENSION = 77;
    public static final byte CLASS_IMPLICITSPEC = 73;
    public static final byte CLASS_VARIABLEACCESS = 86;

    private PhotranVPGSerializer() {
    }

    protected static IOException readFailure() {
        return new IOException(Messages.PhotranVPGSerializer_AnnotationCorrupted);
    }

    public static void serialize(int annotation, OutputStream out) throws IOException {
        out.write(105);
        PhotranVPGSerializer.writeInt(annotation, out);
    }

    public static void serialize(boolean annotation, OutputStream out) throws IOException {
        out.write(98);
        PhotranVPGSerializer.writeBoolean(annotation, out);
    }

    public static void serialize(String annotation, OutputStream out) throws IOException {
        if (annotation == null) {
            PhotranVPGSerializer.serializeNull(out);
            return;
        }
        out.write(115);
        PhotranVPGSerializer.writeString(annotation, out);
    }

    public static void serialize(IPhotranSerializable annotation, OutputStream out) throws IOException {
        if (annotation == null) {
            PhotranVPGSerializer.serializeNull(out);
            return;
        }
        IPhotranSerializable ann = annotation;
        out.write(ann.getSerializationCode());
        ann.writeTo(out);
    }

    private static void serializeNull(OutputStream out) throws IOException {
        out.write(48);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserialize(InputStream in) {
        try {
            int code = in.read();
            switch (code) {
                case 48: {
                    return null;
                }
                case 115: {
                    return (T)PhotranVPGSerializer.readString(in);
                }
                case 105: {
                    return (T)Integer.valueOf(PhotranVPGSerializer.readInt(in));
                }
                case 98: {
                    return (T)Boolean.valueOf(PhotranVPGSerializer.readBoolean(in));
                }
                case 84: {
                    return (T)PhotranTokenRef.readFrom(in);
                }
                case 68: {
                    return (T)Definition.readFrom(in);
                }
                case 89: {
                    return (T)Type.readFrom(in);
                }
                case 65: {
                    return (T)ArraySpec.readFrom(in);
                }
                case 77: {
                    return (T)Dimension.readFrom(in);
                }
                case 73: {
                    return (T)ImplicitSpec.readFrom(in);
                }
                case 86: {
                    return (T)VariableAccess.readFrom(in);
                }
            }
            throw new Error("Unknown class code in deserialization: " + Integer.toString(code));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static void writeString(String string, OutputStream out) throws IOException {
        if (string == null) {
            PhotranVPGSerializer.writeInt(-1, out);
        } else {
            byte[] stringBytes = string.getBytes();
            PhotranVPGSerializer.writeInt(stringBytes.length, out);
            out.write(stringBytes);
        }
    }

    private static String readString(InputStream in) throws IOException {
        int numBytesInString = PhotranVPGSerializer.readInt(in);
        if (numBytesInString < 0) {
            return null;
        }
        byte[] stringBytes = new byte[numBytesInString];
        in.read(stringBytes);
        return new String(stringBytes);
    }

    private static void writeInt(int value, OutputStream out) throws IOException {
        out.write((value & 0xFF000000) >>> 24);
        out.write((value & 0xFF0000) >>> 16);
        out.write((value & 0xFF00) >>> 8);
        out.write((value & 0xFF) >>> 0);
    }

    private static int readInt(InputStream in) throws IOException {
        byte[] bytes = new byte[4];
        in.read(bytes);
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | (bytes[3] & 0xFF) << 0;
    }

    private static void writeBoolean(boolean value, OutputStream out) throws IOException {
        out.write(value ? 84 : 70);
    }

    private static boolean readBoolean(InputStream in) throws IOException {
        switch (in.read()) {
            case 84: {
                return true;
            }
            case 70: {
                return false;
            }
        }
        throw PhotranVPGSerializer.readFailure();
    }

    public static void serialize(Serializable object, OutputStream out) throws IOException {
        if (object == null) {
            PhotranVPGSerializer.serialize(null, out);
        } else if (object instanceof String) {
            PhotranVPGSerializer.serialize((String)((Object)object), out);
        } else if (object instanceof Integer) {
            PhotranVPGSerializer.serialize((Integer)object, out);
        } else if (object instanceof Boolean) {
            PhotranVPGSerializer.serialize((Boolean)object, out);
        } else if (object instanceof IPhotranSerializable) {
            PhotranVPGSerializer.serialize((IPhotranSerializable)object, out);
        } else {
            throw new IllegalArgumentException("Cannot serialize " + object.getClass().getSimpleName());
        }
    }
}

