/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.util;

public final class OffsetLength {
    private int offset = 0;
    private int length = 0;

    public static int getPositionPastEnd(int offset, int length) {
        return offset + Math.max(length, 1);
    }

    public static boolean contains(int thisOffset, int thisLength, int otherOffset, int otherLength) {
        return thisOffset <= otherOffset && OffsetLength.getPositionPastEnd(otherOffset, otherLength) <= OffsetLength.getPositionPastEnd(thisOffset, thisLength);
    }

    public static boolean contains(int thisOffset, int thisLength, OffsetLength other) {
        return other != null && OffsetLength.contains(thisOffset, thisLength, other.offset, other.length);
    }

    public OffsetLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = Math.max(offset, 0);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = Math.max(length, 0);
    }

    public int getPositionPastEnd() {
        return OffsetLength.getPositionPastEnd(this.offset, this.length);
    }

    public boolean isValid() {
        return this.offset >= 0 && this.length >= 0;
    }

    public boolean contains(OffsetLength other) {
        return OffsetLength.contains(this.offset, this.length, other);
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        OffsetLength other = (OffsetLength)o;
        return this.offset == other.offset && this.length == other.length;
    }

    public int hashCode() {
        return 19 * this.offset + this.length;
    }

    public boolean isOnOrAfter(int targetOffset) {
        return this.offset >= targetOffset;
    }

    public boolean isBefore(int targetOffset) {
        return this.offset < targetOffset;
    }

    public String toString() {
        return "offset " + this.offset + ", length " + this.length;
    }
}

