/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.parser.ASTListNode;
import org.eclipse.photran.internal.core.parser.ASTPauseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTPrintStmtNode;
import org.eclipse.photran.internal.core.parser.ASTReadStmtNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class RemovePauseStmtRefactoring
extends FortranEditorRefactoring {
    private ASTPauseStmtNode selectedPauseStmt = null;

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.selectedPauseStmt = RemovePauseStmtRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor, ASTPauseStmtNode.class);
        if (this.selectedPauseStmt == null) {
            this.fail(Messages.RemovePauseStmtRefactoring_PleaseSelectAPauseStatement);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.changePauseStmt();
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
    }

    private void changePauseStmt() {
        String pauseMessage = "''";
        if (this.selectedPauseStmt.getStringConst() != null) {
            pauseMessage = this.selectedPauseStmt.getStringConst().getText();
        }
        String indent = this.selectedPauseStmt.findFirstToken().getWhiteBefore();
        ASTPrintStmtNode printStmt = (ASTPrintStmtNode)RemovePauseStmtRefactoring.parseLiteralStatement(String.valueOf(indent) + "PRINT *, " + pauseMessage + this.selectedPauseStmt.findLastToken().getWhiteBefore() + EOL);
        if (this.selectedPauseStmt.getLabel() != null) {
            printStmt.setLabel(this.selectedPauseStmt.getLabel());
        }
        this.selectedPauseStmt.replaceWith(printStmt);
        indent = indent.substring(indent.lastIndexOf(10) + 1);
        ASTReadStmtNode readStmt = (ASTReadStmtNode)RemovePauseStmtRefactoring.parseLiteralStatement(String.valueOf(indent) + "READ (*, *)" + EOL);
        ASTListNode listNode = (ASTListNode)this.selectedPauseStmt.getParent();
        listNode.insertAfter(printStmt, readStmt);
    }

    @Override
    public String getName() {
        return Messages.RemovePauseStmtRefactoring_Name;
    }
}

