/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.c.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.photran.internal.core.preprocessor.c.CPreprocessor;
import org.eclipse.photran.internal.core.preprocessor.c.EndOfFileException;
import org.eclipse.photran.internal.core.preprocessor.c.FileCodeReaderFactory;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;
import org.eclipse.photran.internal.core.preprocessor.c.OffsetLimitReachedException;
import org.eclipse.photran.internal.core.preprocessor.c.ReaderBasedCodeReader;
import org.eclipse.photran.internal.core.preprocessor.c.TokenTypeTranslator;

public class CppHelper {
    private boolean useRawTokens = true;
    private CPreprocessor cpp;
    private boolean finished = false;

    public CppHelper(String filename, Reader in, String[] includeSearchPaths) throws IOException {
        this.cpp = new CPreprocessor(new ReaderBasedCodeReader(filename, in), (IScannerInfo)new ScannerInfo(null, includeSearchPaths), ParserLanguage.C, (IParserLogService)new NullLogService(), (IScannerExtensionConfiguration)new GCCScannerExtensionConfiguration(), FileCodeReaderFactory.getInstance());
    }

    public CppHelper(IResource infoProvider, String filename, Reader in) throws IOException {
        if (filename == null) {
            filename = "";
        }
        ScannerInfo scanInfo = new ScannerInfo();
        if (infoProvider != null) {
            IScannerInfo buildScanInfo;
            filename = infoProvider.getFullPath().toString();
            IProject project = infoProvider.getProject();
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
            if (provider != null && (buildScanInfo = provider.getScannerInformation(infoProvider)) != null) {
                scanInfo = buildScanInfo;
            }
        }
        this.cpp = new CPreprocessor(new ReaderBasedCodeReader(filename, in), (IScannerInfo)new ScannerInfo(scanInfo.getDefinedSymbols(), scanInfo.getIncludePaths()), ParserLanguage.C, (IParserLogService)new NullLogService(), (IScannerExtensionConfiguration)new GCCScannerExtensionConfiguration(), FileCodeReaderFactory.getInstance());
    }

    public CppHelper(File file) throws IOException {
        this.cpp = new CPreprocessor(new CodeReader(file.getAbsolutePath()), (IScannerInfo)new ScannerInfo(), ParserLanguage.C, (IParserLogService)new NullLogService(), (IScannerExtensionConfiguration)new GCCScannerExtensionConfiguration(), FileCodeReaderFactory.getInstance());
    }

    public CppHelper(String filename) throws IOException {
        this(new File(filename));
    }

    public IToken nextToken() throws OffsetLimitReachedException {
        if (this.finished) {
            return null;
        }
        if (this.useRawTokens) {
            IToken next = this.cpp.nextTokenRaw();
            if (next.getType() == 144) {
                this.finished = true;
            }
            return next;
        }
        IToken next = null;
        try {
            next = this.cpp.nextToken();
        }
        catch (EndOfFileException endOfFileException) {
            this.finished = true;
            return null;
        }
        return next;
    }

    public IToken getRemainingTokens() throws OffsetLimitReachedException {
        IToken first;
        IToken t = first = this.nextToken();
        while (t != null) {
            t = this.nextToken();
        }
        return first;
    }

    public static IToken getAncestor(IToken t, boolean ignoreCarriageReturnAncestors) {
        IToken lastParent = t;
        IToken parent = lastParent.getParent();
        while (parent != null) {
            lastParent = parent;
            parent = lastParent.getParent();
        }
        if (ignoreCarriageReturnAncestors && t.getType() == -99 && lastParent.getImage().equals("\r\n") && Arrays.equals(t.getCharPrecedingWhiteSpace(), lastParent.getCharPrecedingWhiteSpace())) {
            return t;
        }
        return lastParent;
    }

    public static IToken getAncestor(IToken t) {
        return CppHelper.getAncestor(t, false);
    }

    public static IToken getIncludeParent(IToken t) {
        IToken p = t.getParent();
        while (p != null) {
            if (p.getIncludeFile() != null) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    public static String getImage(IToken t) {
        if (t.getType() == -99) {
            return "\n";
        }
        return t.getImage();
    }

    public static String getPreWhiteSpace(IToken t) {
        return t.getPrecedingWhiteSpace();
    }

    public static int getPreWhiteSpaceLength(IToken t) {
        return t.getCharPrecedingWhiteSpace().length;
    }

    public static int getImageLength(IToken t) {
        if (t.getType() == -99) {
            return 1;
        }
        return t.getCharImage().length;
    }

    public static String getFullImage(IToken t) {
        return String.valueOf(CppHelper.getPreWhiteSpace(t)) + CppHelper.getImage(t);
    }

    public static int getFullImageLength(IToken t) {
        return CppHelper.getPreWhiteSpaceLength(t) + CppHelper.getImageLength(t);
    }

    public static String getTokenDetails(IToken t, String spaceSeparator, String tokenSeparator, boolean printTypes) {
        StringBuffer buffer = new StringBuffer(200);
        while (true) {
            if (printTypes) {
                buffer.append(TokenTypeTranslator.typeToString(t.getType()));
                buffer.append(spaceSeparator);
            }
            CppHelper.appendNeatString(buffer, t.getCharPrecedingWhiteSpace());
            buffer.append(spaceSeparator);
            if (t.getType() == -99) {
                buffer.append("\\n");
            } else {
                CppHelper.appendNeatString(buffer, t.getCharImage());
            }
            t = t.getParent();
            if (t == null) break;
            buffer.append(tokenSeparator);
        }
        return buffer.toString();
    }

    public static String reproduceSourceCode(IToken startToken, boolean ignoreCarriageReturnAncestors) {
        StringBuffer buffer = new StringBuffer(4096);
        IToken lastAncestor = null;
        IToken t = startToken;
        while (t != null) {
            IToken ancestor = CppHelper.getAncestor(t, ignoreCarriageReturnAncestors);
            if (ancestor != lastAncestor) {
                buffer.append(CppHelper.getFullImage(ancestor));
                lastAncestor = ancestor;
            }
            t = t.getNext();
        }
        return buffer.toString();
    }

    public static String reproduceSourceCode(IToken startToken) {
        return CppHelper.reproduceSourceCode(startToken, false);
    }

    private static void appendNeatString(StringBuffer buffer, char[] chars) {
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
            ++i;
        }
    }
}

