/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.FileOrIFile;
import org.eclipse.photran.internal.core.preprocessor.c.CppHelper;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;

public class IncludeMap {
    private ArrayList<FileLoc> fileLocStack = new ArrayList();
    private IToken curToken = null;
    private int imageOffset = 0;
    private int streamOffset = 0;

    public IncludeMap(IToken startToken) {
        this(startToken, null);
    }

    public IncludeMap(IToken startToken, IFile file) {
        this.fileLocStack.add(new FileLoc(file));
        this.changeCurToken(startToken);
        this.setStreamOffset(0);
    }

    public void setStreamOffset(int newStreamOffset) {
        int distance = newStreamOffset - this.streamOffset;
        if (distance < 0) {
            throw new IllegalArgumentException("newStreamOffset must be >= the previous stream offset");
        }
        this.streamOffset = newStreamOffset;
        if (this.curToken == null) {
            return;
        }
        String tokenImage = CppHelper.getFullImage(this.curToken).substring(this.imageOffset);
        while (distance >= tokenImage.length()) {
            distance -= tokenImage.length();
            if (IncludeMap.isTokenSourceCode(this.curToken)) {
                this.passSourceCode(tokenImage);
            }
            this.changeCurToken(this.curToken.getNext());
            this.imageOffset = 0;
            if (this.curToken == null) {
                return;
            }
            tokenImage = CppHelper.getFullImage(this.curToken);
        }
        if (IncludeMap.isTokenSourceCode(this.curToken)) {
            this.passSourceCode(tokenImage.substring(0, distance));
        }
        this.imageOffset += distance;
    }

    public FileOrIFile getFileOrIFile() {
        return this.activeFileLoc().fileOrIFile;
    }

    public int getFileOffset() {
        return this.activeFileLoc().offset;
    }

    public int getLine() {
        return this.activeFileLoc().line;
    }

    public int getCol() {
        return this.activeFileLoc().col;
    }

    private void changeCurToken(IToken nextToken) {
        if (this.curToken != null && this.curToken.getType() == -192) {
            this.fileLocStack.remove(this.fileLocStack.size() - 1);
        }
        FileLoc fileLoc = this.activeFileLoc();
        IToken oldProducer = IncludeMap.getProducer(this.curToken, fileLoc.includeDir);
        IToken newProducer = IncludeMap.getProducer(nextToken, fileLoc.includeDir);
        if (oldProducer != null && oldProducer != newProducer) {
            this.passSourceCode(CppHelper.getFullImage(oldProducer));
        }
        if (nextToken != null && nextToken.getType() == -193) {
            IToken includeDir = nextToken.getParent();
            while (includeDir.getIncludeFile() == null) {
                includeDir = includeDir.getParent();
            }
            this.fileLocStack.add(new FileLoc(includeDir));
        }
        this.curToken = nextToken;
    }

    private void passSourceCode(String code) {
        FileLoc fileLoc = this.activeFileLoc();
        int codeLength = code.length();
        FileLoc fileLoc2 = fileLoc;
        fileLoc2.offset = fileLoc2.offset + codeLength;
        int i = 0;
        while (i < codeLength) {
            switch (code.charAt(i)) {
                case '\n': {
                    FileLoc fileLoc3 = fileLoc;
                    fileLoc3.line = fileLoc3.line + 1;
                    fileLoc.col = 1;
                    break;
                }
                default: {
                    FileLoc fileLoc4 = fileLoc;
                    fileLoc4.col = fileLoc4.col + 1;
                }
            }
            ++i;
        }
    }

    private FileLoc activeFileLoc() {
        return this.fileLocStack.get(this.fileLocStack.size() - 1);
    }

    private static IToken getProducer(IToken token, IToken blockingAncestor) {
        if (token == null) {
            return null;
        }
        IToken last = null;
        IToken p = token.getParent();
        while (p != blockingAncestor) {
            last = p;
            p = p.getParent();
        }
        return last;
    }

    private static boolean isTokenSourceCode(IToken token) {
        IToken parent = token.getParent();
        return parent == null || parent.getIncludeFile() != null;
    }

    private static class FileLoc {
        private final IToken includeDir;
        private final FileOrIFile fileOrIFile;
        private int line = 1;
        private int col = 1;
        private int offset = 0;

        private FileLoc(IFile file) {
            this.includeDir = null;
            this.fileOrIFile = new FileOrIFile(file);
        }

        private FileLoc(IToken includeDir) {
            this.includeDir = includeDir;
            this.fileOrIFile = new FileOrIFile(new File(includeDir.getIncludeFile()));
        }
    }
}

