/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.advices;

import java.util.List;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.edit.commands.util.PinUpdateCommand;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.IPinUpdater;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.PinUpdaterFactory;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.intermediateactions.StartObjectBehaviorActionPinUpdater;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.preferences.AutomatedModelCompletionPreferencesInitializer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StartObjectBehaviorAction;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class ParameterEditHelperAdvice
extends AbstractEditHelperAdvice {
    public ICommand getAfterSetCommand(SetRequest request) {
        if (request.getFeature().equals(UMLPackage.eINSTANCE.getTypedElement_Type()) || request.getFeature().equals(UMLPackage.eINSTANCE.getMultiplicityElement_Lower()) || request.getFeature().equals(UMLPackage.eINSTANCE.getMultiplicityElement_Upper()) || request.getFeature().equals(UMLPackage.eINSTANCE.getParameter_Direction()) || request.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
            IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
            boolean synchronizePinPreference = false;
            CompositeCommand command = new CompositeCommand("Update parameter");
            Parameter parameter = (Parameter)request.getElementToEdit();
            Package root = PackageUtil.getRootPackage((Element)parameter);
            if (root != null) {
                synchronizePinPreference = prefStore.getString("org.eclipse.papyrus.uml.diagram.activity.preferences.acceptCallAction").equals(AutomatedModelCompletionPreferencesInitializer.PIN_SYNCHRONIZATION);
                if (synchronizePinPreference) {
                    List allAcceptCallAction = ElementUtil.getInstancesFilteredByType((Package)root, AcceptCallAction.class, null);
                    for (AcceptCallAction acceptCallAction : allAcceptCallAction) {
                        if (!(acceptCallAction instanceof AcceptCallAction)) continue;
                        for (Trigger t : acceptCallAction.getTriggers()) {
                            if (!(t.getEvent() instanceof CallEvent)) continue;
                            for (Parameter p : ((CallEvent)t.getEvent()).getOperation().getOwnedParameters()) {
                                if (p != parameter) continue;
                                IPinUpdater updater = PinUpdaterFactory.getInstance().instantiate((ActivityNode)acceptCallAction);
                                command.add(new PinUpdateCommand<AcceptCallAction>("Update accept event action pins", updater, acceptCallAction));
                            }
                        }
                    }
                }
                if (synchronizePinPreference = prefStore.getString("org.eclipse.papyrus.uml.diagram.activity.preferences.startObjectBehaviorAction").equals(AutomatedModelCompletionPreferencesInitializer.PIN_SYNCHRONIZATION)) {
                    List allStartObjectBahaviorAction = ElementUtil.getInstancesFilteredByType((Package)root, StartObjectBehaviorAction.class, null);
                    for (StartObjectBehaviorAction startObjectBehaviorAction : allStartObjectBahaviorAction) {
                        StartObjectBehaviorActionPinUpdater updater;
                        if (ParameterEditHelperAdvice.isParameterReferenceAPin(parameter, (List<? extends Pin>)startObjectBehaviorAction.getArguments())) {
                            updater = new StartObjectBehaviorActionPinUpdater();
                            command.add(new PinUpdateCommand<StartObjectBehaviorAction>("Update start object behavior action pins", updater, startObjectBehaviorAction));
                        }
                        if (!ParameterEditHelperAdvice.isParameterReferenceAPin(parameter, (List<? extends Pin>)startObjectBehaviorAction.getResults())) continue;
                        updater = new StartObjectBehaviorActionPinUpdater();
                        command.add(new PinUpdateCommand<StartObjectBehaviorAction>("Update start object behavior action pins", updater, startObjectBehaviorAction));
                    }
                }
            }
            if (!command.isEmpty()) {
                return command;
            }
        }
        return super.getAfterSetCommand(request);
    }

    private static boolean isParameterReferenceAPin(Parameter parameter, List<? extends Pin> pins) {
        for (Pin pin : pins) {
            if (!ParameterEditHelperAdvice.pinParameterMatch(pin, parameter)) continue;
            return true;
        }
        return false;
    }

    private static <P extends Pin> boolean pinParameterMatch(P pin, Parameter parameter) {
        boolean match = true;
        match = pin.getType() == parameter.getType();
        if (parameter.getDirection() == ParameterDirectionKind.OUT_LITERAL | parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
            match = pin instanceof OutputPin;
        } else if (parameter.getDirection() == ParameterDirectionKind.IN_LITERAL) {
            match = pin instanceof InputPin;
        }
        if (match && parameter.getName() != null) {
            match = pin.getName().matches("\\[[a-z]+\\]\\s.*") ? pin.getName().replaceFirst("\\[[a-z]+\\]\\s", "").equals(parameter.getName()) : pin.getName().equals(parameter.getName());
        }
        if (match) {
            boolean bl = match = pin.getLower() == parameter.getLower();
            if (match) {
                match = pin.getUpper() == parameter.getUpper();
            }
        }
        return match;
    }
}

