/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.util.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyResolver
extends WorkerPool<ProxyResolver, Resource, ResolveJob> {
    private ResourceSet resourceSet;

    public ProxyResolver(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    protected ResolveJob createWorker(Resource key, int workerID, boolean secondary) {
        ResolveJob resolveJob = new ResolveJob(this, key, workerID, secondary);
        resolveJob.setSystem(true);
        return resolveJob;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void begin(IProgressMonitor monitor) {
        super.begin("Resolving", monitor);
    }

    protected void run(String taskName, final IProgressMonitor monitor) {
        final EList resources = this.resourceSet.getResources();
        monitor.setTaskName("Resolving");
        monitor.subTask("Resolving proxies of " + resources.size() + " resources");
        AdapterImpl adapter = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getEventType() == 3) {
                    Resource resource = (Resource)notification.getNewValue();
                    ProxyResolver.this.schedule(resource);
                    monitor.subTask("Resolving proxies of " + resources.size() + " resources");
                }
            }
        };
        try {
            this.resourceSet.eAdapters().add((Object)adapter);
            this.perform(new ArrayList(resources));
        }
        finally {
            this.resourceSet.eAdapters().remove((Object)adapter);
        }
    }

    public void dispose() {
        this.resourceSet = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveJob
    extends WorkerPool.Worker<Resource, ProxyResolver> {
        private final ResourceSet resourceSet = ((ProxyResolver)this.getWorkPool()).getResourceSet();

        private ResolveJob(ProxyResolver proxyResolver, Resource resource, int id, boolean secondary) {
            super("Resolver", (WorkerPool)proxyResolver, (Object)resource, id, secondary);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus perform(IProgressMonitor monitor) {
            EList contents;
            ResourceSet resourceSet = this.resourceSet;
            synchronized (resourceSet) {
                contents = ((Resource)this.getKey()).getContents();
            }
            for (EObject eObject : contents) {
                this.visit(eObject);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visit(EObject eObject) {
            EClass eClass = eObject.eClass();
            ArrayList<InternalEObject> properContentObjects = new ArrayList<InternalEObject>();
            for (EReference eReference : eClass.getEAllReferences()) {
                boolean containment;
                block20: {
                    if (eReference.isDerived()) continue;
                    containment = eReference.isContainment();
                    if (eReference.isMany()) {
                        InternalEList internalEList = (InternalEList)eObject.eGet((EStructuralFeature)eReference);
                        int i = 0;
                        while (true) {
                            try {
                                while (true) {
                                    InternalEObject referencedEObject;
                                    ResourceSet resourceSet = this.resourceSet;
                                    synchronized (resourceSet) {
                                        if (i >= internalEList.size()) {
                                            break block20;
                                        }
                                        referencedEObject = (InternalEObject)internalEList.get(i);
                                    }
                                    ++i;
                                    if (!containment || referencedEObject.eDirectResource() != null) continue;
                                    properContentObjects.add(referencedEObject);
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                InternalEObject referencedEObject2 = (InternalEObject)internalEList.basicGet(i);
                                URI eProxyURI = referencedEObject2.eProxyURI();
                                if (eProxyURI != null) {
                                    ++i;
                                    referencedEObject2.eSetProxyURI(BaseUtil.createBogusURI((URI)eProxyURI));
                                    continue;
                                }
                                internalEList.remove(i);
                                continue;
                            }
                            break;
                        }
                    }
                    try {
                        InternalEObject internalEObject;
                        ResourceSet i = this.resourceSet;
                        synchronized (i) {
                            internalEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference);
                        }
                        if (internalEObject != null && containment && internalEObject.eDirectResource() == null) {
                            properContentObjects.add(internalEObject);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        InternalEObject internalEObject = (InternalEObject)eObject.eGet((EStructuralFeature)eReference, false);
                        URI eProxyURI = internalEObject.eProxyURI();
                        if (eProxyURI != null) {
                            internalEObject.eSetProxyURI(BaseUtil.createBogusURI((URI)eProxyURI));
                        }
                        eObject.eSet((EStructuralFeature)eReference, null);
                    }
                }
                if (containment && !properContentObjects.isEmpty()) {
                    for (EObject eObject2 : properContentObjects) {
                        this.visit(eObject2);
                    }
                }
                properContentObjects.clear();
            }
        }
    }
}

