/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmTypeHelper;
import org.eclipse.objectteams.otredyn.bytecode.asm.StackBalanceAnalyzer;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class AbstractTransformableClassNode
extends ClassNode {
    static final boolean IS_DEBUG = System.getProperty("ot.debug") != null;

    public AbstractTransformableClassNode() {
        super(327680);
    }

    protected InsnList getBoxingInstructions(Type[] args, boolean isStatic) {
        int firstArgIndex = 1;
        if (isStatic) {
            firstArgIndex = 0;
        }
        InsnList instructions = new InsnList();
        instructions.add(this.createLoadIntConstant(args.length));
        instructions.add((AbstractInsnNode)new TypeInsnNode(189, ClassNames.OBJECT_SLASH));
        int i = 0;
        int slot = 0;
        while (i < args.length) {
            instructions.add((AbstractInsnNode)new InsnNode(89));
            instructions.add(this.createLoadIntConstant(i));
            instructions.add((AbstractInsnNode)new IntInsnNode(args[i].getOpcode(21), slot + firstArgIndex));
            if (args[i].getSort() != 10 && args[i].getSort() != 9) {
                instructions.add(AsmTypeHelper.getBoxingInstructionForType(args[i]));
            }
            instructions.add((AbstractInsnNode)new InsnNode(83));
            slot += args[i++].getSize();
        }
        return instructions;
    }

    protected InsnList getUnboxingInstructionsForReturnValue(Type returnType) {
        InsnList instructions = new InsnList();
        switch (returnType.getSort()) {
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(87));
                instructions.add((AbstractInsnNode)new InsnNode(177));
                break;
            }
            case 9: 
            case 10: {
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, returnType.getInternalName()));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                break;
            }
            default: {
                String objectType = AsmTypeHelper.getBoxingType(returnType);
                instructions.add((AbstractInsnNode)new TypeInsnNode(192, objectType));
                instructions.add(AsmTypeHelper.getUnboxingInstructionForType(returnType, objectType));
                instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
            }
        }
        return instructions;
    }

    protected void addNewLabelToSwitch(InsnList instructions, InsnList newInstructions, int labelIndex) {
        ListIterator iter = instructions.iterator();
        LookupSwitchInsnNode lSwitch = null;
        while (iter.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iter.next();
            if (node.getType() != 12) continue;
            lSwitch = (LookupSwitchInsnNode)node;
            LabelNode label = new LabelNode();
            boolean labelAdded = false;
            int i = 0;
            while (i < lSwitch.keys.size()) {
                Integer key = (Integer)lSwitch.keys.get(i);
                if (key >= labelIndex) {
                    lSwitch.keys.add(i, labelIndex);
                    lSwitch.labels.add(i, label);
                    labelAdded = true;
                    break;
                }
                ++i;
            }
            if (!labelAdded) {
                lSwitch.labels.add(label);
                lSwitch.keys.add(labelIndex);
            }
            boolean foundDefLabel = false;
            AbstractInsnNode prevNode = node;
            while (iter.hasNext()) {
                node = (AbstractInsnNode)iter.next();
                if (node.getType() == 8) {
                    if (foundDefLabel) break;
                    foundDefLabel = true;
                }
                prevNode = node;
            }
            instructions.insert(prevNode, (AbstractInsnNode)label);
            instructions.insert((AbstractInsnNode)label, newInstructions);
            break;
        }
        if (lSwitch == null) {
            throw new RuntimeException("No switch statement found.");
        }
    }

    protected MethodNode getMethod(Method method) {
        List methodList = this.methods;
        for (MethodNode methodNode : methodList) {
            if (methodNode.name.compareTo(method.getName()) != 0 || methodNode.desc.compareTo(method.getSignature()) != 0) continue;
            return methodNode;
        }
        return null;
    }

    protected InsnList getInstructionsForDebugOutput(String message) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "java/lang/System", "out", "Ljava/io/PrintStream;"));
        instructions.add((AbstractInsnNode)new LdcInsnNode((Object)message));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false));
        return instructions;
    }

    protected InsnList getInstructionsForDebugObjectOutput(AbstractInsnNode getObjectInsn) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "java/lang/System", "out", "Ljava/io/PrintStream;"));
        instructions.add(getObjectInsn);
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V", false));
        return instructions;
    }

    protected InsnList getInstructionsForDebugIntOutput(AbstractInsnNode getIntInsn) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, "java/lang/System", "out", "Ljava/io/PrintStream;"));
        instructions.add(getIntInsn);
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/io/PrintStream", "println", "(I)V", false));
        return instructions;
    }

    protected void addInstructionsForLoadArguments(InsnList instructions, Type[] args, boolean isStatic) {
        int firstArgIndex = 1;
        if (isStatic) {
            firstArgIndex = 0;
        }
        if (!isStatic) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        int i = 0;
        int slot = firstArgIndex;
        while (i < args.length) {
            instructions.add((AbstractInsnNode)new IntInsnNode(args[i].getOpcode(21), slot));
            slot += args[i++].getSize();
        }
    }

    protected void replaceReturn(InsnList instructions, Type returnType) {
        block3: {
            block2: {
                if (returnType.getSort() == 10 || returnType.getSort() == 9 || returnType.getSort() == 0) break block2;
                for (AbstractInsnNode orgMethodNode : instructions) {
                    if (orgMethodNode.getOpcode() != returnType.getOpcode(172)) continue;
                    instructions.insertBefore(orgMethodNode, AsmTypeHelper.getBoxingInstructionForType(returnType));
                    instructions.set(orgMethodNode, (AbstractInsnNode)new InsnNode(176));
                }
                break block3;
            }
            if (returnType.getSort() != 0) break block3;
            for (AbstractInsnNode orgMethodNode : instructions) {
                if (orgMethodNode.getOpcode() != 177) continue;
                instructions.insertBefore(orgMethodNode, (AbstractInsnNode)new InsnNode(1));
                instructions.insertBefore(orgMethodNode, (AbstractInsnNode)new InsnNode(176));
                instructions.remove(orgMethodNode);
            }
        }
    }

    protected void addReturn(InsnList instructions, Type returnType) {
        switch (returnType.getSort()) {
            case 0: {
                instructions.add((AbstractInsnNode)new InsnNode(177));
                break;
            }
            case 9: 
            case 10: {
                instructions.add((AbstractInsnNode)new InsnNode(1));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                instructions.add((AbstractInsnNode)new InsnNode(3));
                instructions.add((AbstractInsnNode)new InsnNode(172));
                break;
            }
            case 7: {
                instructions.add((AbstractInsnNode)new InsnNode(9));
                instructions.add((AbstractInsnNode)new InsnNode(173));
                break;
            }
            case 6: {
                instructions.add((AbstractInsnNode)new InsnNode(11));
                instructions.add((AbstractInsnNode)new InsnNode(174));
                break;
            }
            case 8: {
                instructions.add((AbstractInsnNode)new InsnNode(14));
                instructions.add((AbstractInsnNode)new InsnNode(175));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type " + returnType);
            }
        }
    }

    protected AbstractInsnNode createLoadIntConstant(int constant) {
        if (constant <= 5) {
            return new InsnNode(3 + constant);
        }
        if (constant < 127) {
            return new IntInsnNode(16, constant);
        }
        if (constant < Short.MAX_VALUE) {
            return new IntInsnNode(17, constant);
        }
        return new LdcInsnNode((Object)constant);
    }

    protected void replaceSuperCallsWithCallToCallOrig(InsnList instructions, List<MethodInsnNode> superCalls, boolean returnsJLObject, AbstractBoundClass superclass, IBoundMethodIdInsnProvider insnProvider) {
        for (MethodInsnNode oldNode : superCalls) {
            superclass.addWeavingOfSubclassTask(oldNode.name, oldNode.desc, oldNode.getOpcode() == 184);
            Type[] args = Type.getArgumentTypes((String)oldNode.desc);
            Type returnType = Type.getReturnType((String)oldNode.desc);
            AbstractInsnNode[] insertionPoints = StackBalanceAnalyzer.findInsertionPointsBefore((AbstractInsnNode)oldNode, args);
            MethodInsnNode firstInsert = insertionPoints.length > 0 ? insertionPoints[0] : oldNode;
            instructions.insertBefore((AbstractInsnNode)firstInsert, insnProvider.getLoadBoundMethodIdInsn(oldNode));
            instructions.insertBefore((AbstractInsnNode)firstInsert, this.createLoadIntConstant(args.length));
            instructions.insertBefore((AbstractInsnNode)firstInsert, (AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
            int i = 0;
            while (i < insertionPoints.length) {
                instructions.insertBefore(insertionPoints[i], (AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insertionPoints[i], this.createLoadIntConstant(i));
                MethodInsnNode insertAt = i + 1 < insertionPoints.length ? insertionPoints[i + 1] : oldNode;
                instructions.insertBefore((AbstractInsnNode)insertAt, AsmTypeHelper.getBoxingInstructionForType(args[i]));
                instructions.insertBefore((AbstractInsnNode)insertAt, (AbstractInsnNode)new InsnNode(83));
                ++i;
            }
            boolean nextIsGeneralizedReturn = false;
            AbstractInsnNode next = oldNode.getNext();
            if (returnsJLObject) {
                boolean bl = nextIsGeneralizedReturn = next != null && next.getOpcode() >= 172 && next.getOpcode() <= 176;
            }
            if (!nextIsGeneralizedReturn) {
                if (returnType == Type.VOID_TYPE) {
                    instructions.insert((AbstractInsnNode)oldNode, (AbstractInsnNode)new InsnNode(87));
                } else {
                    instructions.insert((AbstractInsnNode)oldNode, AsmTypeHelper.getUnboxingInstructionForType(returnType));
                    String expectedReferenceTypeName = AsmTypeHelper.getBoxingType(returnType);
                    if (expectedReferenceTypeName == null) {
                        expectedReferenceTypeName = returnType.getInternalName();
                    }
                    instructions.insert((AbstractInsnNode)oldNode, (AbstractInsnNode)new TypeInsnNode(192, expectedReferenceTypeName));
                }
            }
            MethodInsnNode newMethodNode = new MethodInsnNode(183, oldNode.owner, ConstantMembers.callOrig.getName(), ConstantMembers.callOrig.getSignature(), false);
            instructions.set((AbstractInsnNode)oldNode, (AbstractInsnNode)newMethodNode);
            if (!nextIsGeneralizedReturn || next == null || next.getOpcode() == 176) continue;
            instructions.set(next, (AbstractInsnNode)new InsnNode(176));
        }
    }

    protected void addLocal(MethodNode method, String selector, String desc, int slot) {
        LabelNode end;
        LabelNode start;
        if (!IS_DEBUG) {
            return;
        }
        InsnList instructions = method.instructions;
        if (instructions.getFirst() instanceof LabelNode) {
            start = (LabelNode)instructions.getFirst();
        } else {
            start = new LabelNode();
            instructions.insert((AbstractInsnNode)start);
        }
        if (instructions.getLast() instanceof LabelNode) {
            end = (LabelNode)instructions.getLast();
        } else {
            end = new LabelNode();
            instructions.add((AbstractInsnNode)end);
        }
        this.addLocal(method, selector, desc, slot, start, end, true);
    }

    protected void addLocal(MethodNode method, String selector, String desc, int slot, LabelNode start, LabelNode end, boolean fullRange) {
        if (!IS_DEBUG) {
            return;
        }
        if (fullRange) {
            for (Object lv : method.localVariables) {
                if (!((LocalVariableNode)lv).name.equals(selector)) continue;
                return;
            }
        }
        method.localVariables.add(new LocalVariableNode(selector, desc, null, start, end, slot));
    }

    protected void addThisVariable(MethodNode method) {
        this.addLocal(method, "this", "L" + this.name + ";", 0);
    }

    protected void addLineNumber(InsnList instructions, int line) {
        if (!IS_DEBUG) {
            return;
        }
        LabelNode position = new LabelNode();
        instructions.add((AbstractInsnNode)position);
        instructions.add((AbstractInsnNode)new LineNumberNode(line, position));
    }

    protected int peekFirstLineNumber(InsnList instructions) {
        if (!IS_DEBUG) {
            return -1;
        }
        for (Object insn : instructions) {
            if (!(insn instanceof LineNumberNode)) continue;
            return ((LineNumberNode)insn).line;
        }
        return -1;
    }

    protected abstract boolean transform();

    protected static interface IBoundMethodIdInsnProvider {
        public AbstractInsnNode getLoadBoundMethodIdInsn(MethodInsnNode var1);
    }
}

