/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.refactoring.otrefactorings;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class SelectionActionCommon {
    protected IJavaElement fJavaElement;
    protected JavaEditor fEditor;
    protected IWorkbenchWindow fWindow;

    public SelectionActionCommon(JavaEditor editor) {
        this.fEditor = editor;
    }

    public SelectionActionCommon(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object[] elements = selection.toArray();
        this.filterElements(elements);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) throws JavaModelException {
        Object[] elements = javaTextSelection.resolveElementAtOffset();
        this.filterElements(elements);
    }

    protected abstract void filterElements(Object[] var1);

    public void clearJavaElement() {
        this.fJavaElement = null;
    }

    public void run() {
        this.prepareRun();
        this.doRun();
    }

    protected void prepareRun() {
        if (this.fJavaElement == null) {
            JavaEditor javaEditor = this.fEditor;
            if (javaEditor == null) {
                try {
                    javaEditor = (JavaEditor)this.fWindow.getActivePage().getActiveEditor();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (javaEditor != null) {
                try {
                    Object[] elements = SelectionConverter.codeResolve((JavaEditor)javaEditor);
                    this.filterElements(elements);
                }
                catch (JavaModelException e) {
                    this.fJavaElement = null;
                }
            }
        }
        if (this.fWindow == null && this.fEditor != null) {
            this.fWindow = this.fEditor.getSite().getWorkbenchWindow();
        }
    }

    protected abstract void doRun();
}

