/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.common.collect.Sets;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.gerrit.ui.operations.BranchContentProposal;

public class BranchProposalProvider
implements IContentProposalProvider {
    private final SortedSet<String> proposals;

    public BranchProposalProvider(SortedSet<String> proposals) {
        this.proposals = Sets.newTreeSet(proposals);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Assert.isLegal((contents != null ? 1 : 0) != 0);
        Assert.isLegal((position >= 0 ? 1 : 0) != 0);
        TreeSet branches = Sets.newTreeSet();
        String searchText = contents.toLowerCase();
        this.addMatchingProposals(branches, searchText);
        return branches.toArray(new BranchContentProposal[0]);
    }

    private void addMatchingProposals(SortedSet<BranchContentProposal> branches, String searchText) {
        for (String branchProposal : this.proposals) {
            if (!branchProposal.toLowerCase().contains(searchText)) continue;
            branches.add(new BranchContentProposal(branchProposal));
        }
    }
}

