/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6,
ICompletionProposalExtension7,
IContextInformation {
    private CompletionItem item;
    private int initialOffset = -1;
    private int bestOffset = -1;
    private ITextViewer viewer;
    private IRegion selection;
    private LinkedPosition firstPosition;
    private LanguageServiceAccessor.LSPDocumentInfo info;

    public LSCompletionProposal(@NonNull CompletionItem item, int offset, LanguageServiceAccessor.LSPDocumentInfo info) {
        this.item = item;
        this.info = info;
        this.initialOffset = offset;
        this.bestOffset = this.getPrefixCompletionStart(info.getDocument(), offset);
    }

    public int getBestOffset() {
        return this.bestOffset;
    }

    public CompletionItem getItem() {
        return this.item;
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        String rawString = this.getDisplayString();
        StyledString res = new StyledString(rawString);
        if (offset > this.bestOffset) {
            try {
                String subString = document.get(this.bestOffset, offset - this.bestOffset);
                if (this.item.getTextEdit() != null) {
                    int start = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
                    int end = offset;
                    subString = document.get(start, end - start);
                }
                int lastIndex = 0;
                subString = subString.toLowerCase();
                String lowerRawString = rawString.toLowerCase();
                char[] cArray = subString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Character c = Character.valueOf(cArray[n2]);
                    int index = lowerRawString.indexOf(c.charValue(), lastIndex);
                    if (index < 0) {
                        return res;
                    }
                    res.setStyle(index, 1, boldStylerProvider.getBoldStyler());
                    lastIndex = index + 1;
                    ++n2;
                }
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return res;
    }

    public String getDisplayString() {
        return this.item.getLabel();
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.getDisplayString());
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        };
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        CompletionOptions options;
        ServerCapabilities capabilities = this.info.getCapabilites();
        if (capabilities != null && (options = capabilities.getCompletionProvider()) != null && Boolean.TRUE.equals(options.getResolveProvider())) {
            CompletableFuture resolvedItem = this.info.getLanguageClient().getTextDocumentService().resolveCompletionItem(this.item);
            try {
                this.updateCompletionItem((CompletionItem)resolvedItem.get(500L, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        StringBuilder res = new StringBuilder();
        if (this.item.getDetail() != null) {
            res.append("<p>" + this.item.getDetail() + "</p>");
        }
        if (res.length() > 0) {
            res.append("<br/>");
        }
        if (this.item.getDocumentation() != null) {
            res.append("<p>" + this.item.getDocumentation() + "</p>");
        }
        return res.toString();
    }

    private void updateCompletionItem(CompletionItem resolvedItem) {
        if (resolvedItem == null) {
            return;
        }
        if (resolvedItem.getLabel() != null) {
            this.item.setLabel(resolvedItem.getLabel());
        }
        if (resolvedItem.getKind() != null) {
            this.item.setKind(resolvedItem.getKind());
        }
        if (resolvedItem.getDetail() != null) {
            this.item.setDetail(resolvedItem.getDetail());
        }
        if (resolvedItem.getDocumentation() != null) {
            this.item.setDocumentation(resolvedItem.getDocumentation());
        }
        if (resolvedItem.getInsertText() != null) {
            this.item.setInsertText(resolvedItem.getInsertText());
        }
        if (resolvedItem.getTextEdit() != null) {
            this.item.setTextEdit(resolvedItem.getTextEdit());
        }
        if (resolvedItem.getAdditionalTextEdits() != null) {
            this.item.setAdditionalTextEdits(resolvedItem.getAdditionalTextEdits());
        }
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.item.getInsertText().substring(completionOffset - this.bestOffset);
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        if (this.item.getTextEdit() != null) {
            try {
                return LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        String insertText = this.getInsertText();
        try {
            String subDoc = document.get(Math.max(0, completionOffset - insertText.length()), Math.min(insertText.length(), completionOffset));
            int i = 0;
            while (i < insertText.length() && i < completionOffset) {
                String tentativeCommonString = subDoc.substring(i);
                if (insertText.startsWith(tentativeCommonString)) {
                    return completionOffset - tentativeCommonString.length();
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return completionOffset;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        this.viewer = viewer;
    }

    public void unselected(ITextViewer viewer) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (this.item.getLabel() == null) return false;
        if (this.item.getLabel().isEmpty()) {
            return false;
        }
        if (offset < this.bestOffset) {
            return false;
        }
        try {
            String subString = document.get(this.bestOffset, offset - this.bestOffset);
            String insert = this.getInsertText();
            if (this.item.getTextEdit() != null) {
                int start = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), document);
                int end = offset;
                subString = document.get(start, end - start);
                insert = this.item.getTextEdit().getNewText();
            }
            int lastIndex = 0;
            insert = insert.toLowerCase();
            subString = subString.toLowerCase();
            char[] cArray = subString.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Character c = Character.valueOf(cArray[n2]);
                int index = insert.indexOf(c.charValue(), lastIndex);
                if (index < 0) {
                    return false;
                }
                lastIndex = index + 1;
                ++n2;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.viewer = viewer;
        this.apply(viewer.getDocument(), trigger, stateMask, offset);
    }

    public void apply(IDocument document, char trigger, int offset) {
        this.apply(document, trigger, 0, offset);
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', 0, this.bestOffset);
    }

    private void apply(IDocument document, char trigger, int stateMask, int offset) {
        String insertText = null;
        TextEdit textEdit = this.item.getTextEdit();
        try {
            Position end;
            Position start;
            if (textEdit == null) {
                insertText = this.getInsertText();
                start = LSPEclipseUtils.toPosition(this.bestOffset, document);
                end = LSPEclipseUtils.toPosition(offset, document);
                textEdit = new TextEdit(new Range(start, end), insertText);
            } else if (offset > this.initialOffset) {
                int shift = offset - this.initialOffset;
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + shift);
            }
            start = textEdit.getRange().getStart();
            end = textEdit.getRange().getEnd();
            if (start.getLine() > end.getLine() || start.getLine() == end.getLine() && start.getCharacter() > end.getCharacter()) {
                textEdit.getRange().setEnd(start);
                textEdit.getRange().setStart(end);
            }
            Position documentEnd = LSPEclipseUtils.toPosition(document.getLength(), document);
            Position textEditEnd = textEdit.getRange().getEnd();
            if (documentEnd.getLine() < textEditEnd.getLine() || documentEnd.getLine() == textEditEnd.getLine() && documentEnd.getCharacter() < textEditEnd.getCharacter()) {
                textEdit.getRange().setEnd(documentEnd);
            }
            if (insertText != null) {
                int shift = offset - this.bestOffset;
                int commonSize = 0;
                while (commonSize < insertText.length() - shift && document.getLength() > offset + commonSize && document.getChar(this.bestOffset + shift + commonSize) == insertText.charAt(commonSize + shift)) {
                    ++commonSize;
                }
                textEdit.getRange().getEnd().setCharacter(textEdit.getRange().getEnd().getCharacter() + commonSize);
            }
            insertText = textEdit.getNewText();
            LinkedHashMap<String, LinkedPositionGroup> groups = new LinkedHashMap<String, LinkedPositionGroup>();
            if (this.item.getInsertTextFormat() == InsertTextFormat.Snippet) {
                int insertionOffset = LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document);
                int currentOffset = 0;
                while ((currentOffset = insertText.indexOf(36, currentOffset)) != -1) {
                    StringBuilder keyBuilder = new StringBuilder();
                    String defaultValue = "";
                    int length = 1;
                    while (currentOffset + length < insertText.length() && Character.isDigit(insertText.charAt(currentOffset + length))) {
                        keyBuilder.append(insertText.charAt(currentOffset + length));
                        ++length;
                    }
                    if (length == 1 && insertText.length() >= 2 && insertText.charAt(currentOffset + 1) == '{') {
                        ++length;
                        while (currentOffset + length < insertText.length() && Character.isDigit(insertText.charAt(currentOffset + length))) {
                            keyBuilder.append(insertText.charAt(currentOffset + length));
                            ++length;
                        }
                        if (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) == ':') {
                            ++length;
                        }
                        while (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) != '}') {
                            defaultValue = String.valueOf(defaultValue) + insertText.charAt(currentOffset + length);
                            ++length;
                        }
                        if (currentOffset + length < insertText.length() && insertText.charAt(currentOffset + length) == '}') {
                            ++length;
                        }
                    }
                    if (keyBuilder.length() > 0) {
                        String key = keyBuilder.toString();
                        if (!groups.containsKey(key)) {
                            groups.put(key, new LinkedPositionGroup());
                        }
                        insertText = String.valueOf(insertText.substring(0, currentOffset)) + defaultValue + insertText.substring(currentOffset + length);
                        LinkedPosition position = new LinkedPosition(document, insertionOffset + currentOffset, defaultValue.length());
                        if (this.firstPosition == null) {
                            this.firstPosition = position;
                        }
                        ((LinkedPositionGroup)groups.get(key)).addPosition(this.firstPosition);
                        currentOffset += defaultValue.length();
                        continue;
                    }
                    ++currentOffset;
                }
            }
            textEdit.setNewText(insertText);
            LSPEclipseUtils.applyEdit(textEdit, document);
            if (this.viewer != null && !groups.isEmpty()) {
                LinkedModeModel model = new LinkedModeModel();
                for (LinkedPositionGroup group : groups.values()) {
                    model.addGroup(group);
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            } else {
                this.selection = new Region(LSPEclipseUtils.toOffset(textEdit.getRange().getStart(), document) + textEdit.getNewText().length(), 0);
            }
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
    }

    private String getInsertText() {
        String insertText = this.item.getInsertText();
        if (this.item.getTextEdit() != null) {
            insertText = this.item.getTextEdit().getNewText();
        }
        if (insertText == null) {
            insertText = this.item.getLabel();
        }
        return insertText;
    }

    public char[] getTriggerCharacters() {
        return null;
    }

    public int getContextInformationPosition() {
        return 131072;
    }

    public Point getSelection(IDocument document) {
        if (this.firstPosition != null) {
            return new Point(this.firstPosition.getOffset(), this.firstPosition.getLength());
        }
        if (this.selection == null) {
            return null;
        }
        return new Point(this.selection.getOffset(), this.selection.getLength());
    }

    public String getAdditionalProposalInfo() {
        return this.item.getDetail();
    }

    public Image getImage() {
        return LSPImages.imageFromCompletionItem(this.item);
    }

    public IContextInformation getContextInformation() {
        return this;
    }

    public String getContextDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getInformationDisplayString() {
        return this.getAdditionalProposalInfo();
    }

    public String getSortText() {
        if (this.item.getSortText() != null && !this.item.getSortText().isEmpty()) {
            return this.item.getSortText();
        }
        return this.item.getLabel();
    }

    public int getNumberOfModifsBeforeOffset() {
        if (this.item.getTextEdit() == null) {
            return 0;
        }
        int res = 0;
        try {
            int startOffset = LSPEclipseUtils.toOffset(this.item.getTextEdit().getRange().getStart(), this.info.getDocument());
            String insert = this.item.getTextEdit().getNewText();
            String subDoc = this.info.getDocument().get(startOffset, Math.min(startOffset + insert.length(), this.info.getDocument().getLength() - startOffset));
            int i = 0;
            while (i < subDoc.length() && i < insert.length()) {
                if (subDoc.charAt(i) != insert.charAt(i)) {
                    ++res;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }
}

