/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.binutils.utils.STStrings;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.model.CovFileTreeElement;
import org.eclipse.linuxtools.internal.gcov.model.CovFolderTreeElement;
import org.eclipse.linuxtools.internal.gcov.model.CovFunctionTreeElement;
import org.eclipse.linuxtools.internal.gcov.model.CovRootTreeElement;
import org.eclipse.linuxtools.internal.gcov.parser.Folder;
import org.eclipse.linuxtools.internal.gcov.parser.GcdaRecordsParser;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoFunction;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoRecordsParser;
import org.eclipse.linuxtools.internal.gcov.parser.Messages;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CovManager
implements Serializable {
    private static final long serialVersionUID = 5582066617970911413L;
    private static String winOSType = "";
    private final String binaryPath;
    private final ArrayList<Folder> allFolders = new ArrayList();
    private final ArrayList<SourceFile> allSrcs = new ArrayList();
    private final ArrayList<GcnoFunction> allFnctns = new ArrayList();
    private final HashMap<String, SourceFile> sourceMap = new HashMap();
    private long nbrPgmRuns = 0L;
    private CovRootTreeElement rootNode;
    private final IProject project;

    public CovManager(String binaryPath, IProject project) {
        this.binaryPath = binaryPath;
        this.project = project;
    }

    public CovManager(String binaryPath) {
        this(binaryPath, null);
    }

    public void processCovFiles(List<String> covFilesPaths, String initialGcda) throws CoreException, IOException {
        GcdaRecordsParser daRcrd = null;
        HashMap<File, File> sourcePath = new HashMap<File, File>();
        if (initialGcda != null) {
            File initialGcdaFile = new File(initialGcda).getAbsoluteFile();
            for (String s : covFilesPaths) {
                File gcda = new File(s).getAbsoluteFile();
                if (!gcda.getName().equals(initialGcdaFile.getName()) || gcda.equals(initialGcdaFile)) continue;
                if (!sourcePath.isEmpty()) {
                    sourcePath.clear();
                    break;
                }
                this.addSourceLookup(sourcePath, initialGcdaFile, gcda);
            }
        }
        for (String gcdaPath : covFilesPaths) {
            String gcnoPath = gcdaPath.replace(".gcda", ".gcno");
            DataInput traceFile = this.openTraceFileStream(gcnoPath, ".gcno", sourcePath);
            if (traceFile == null) {
                return;
            }
            GcnoRecordsParser noRcrd = new GcnoRecordsParser(this.sourceMap, this.allSrcs);
            noRcrd.parseData(traceFile);
            for (GcnoFunction f : noRcrd.getFnctns()) {
                this.allFnctns.add(f);
            }
            if (traceFile.getClass() == DataInputStream.class) {
                ((DataInputStream)traceFile).close();
            }
            if ((traceFile = this.openTraceFileStream(gcdaPath, ".gcda", sourcePath)) == null) {
                return;
            }
            if (noRcrd.getFnctns().isEmpty()) {
                String message = NLS.bind((String)Messages.CovManager_No_Funcs_Error, (Object)gcnoPath);
                Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                throw new CoreException((IStatus)status);
            }
            daRcrd = new GcdaRecordsParser(noRcrd.getFnctns());
            daRcrd.parseGcdaRecord(traceFile);
            if (traceFile.getClass() != DataInputStream.class) continue;
            ((DataInputStream)traceFile).close();
        }
        if (daRcrd != null) {
            this.nbrPgmRuns = daRcrd.getPgmSmryNbrPgmRuns();
        }
        for (GcnoFunction gf : this.allFnctns) {
            gf.solveGraphFnctn();
        }
        for (SourceFile sourceFile : this.allSrcs) {
            sourceFile.createLines();
        }
        for (GcnoFunction gf : this.allFnctns) {
            gf.addLineCounts(this.allSrcs);
        }
        for (SourceFile sf : this.allSrcs) {
            sf.accumulateLineCounts();
        }
        for (SourceFile sf : this.allSrcs) {
            File srcFile = new File(sf.getName());
            String folderName = srcFile.getParent();
            if (folderName == null) {
                folderName = "?";
            }
            Folder folder = null;
            for (Folder f : this.allFolders) {
                if (!f.getPath().equals(folderName)) continue;
                folder = f;
            }
            if (folder == null) {
                folder = new Folder(folderName);
                this.allFolders.add(folder);
            }
            folder.addSrcFiles(sf);
        }
        for (Folder f : this.allFolders) {
            f.accumulateSourcesCounts();
        }
    }

    public void fillGcovView() {
        int summaryTotal = 0;
        int summaryInstrumented = 0;
        int summaryExecuted = 0;
        for (Folder f : this.allFolders) {
            summaryTotal += f.getNumLines();
            summaryInstrumented += f.getLinesInstrumented();
            summaryExecuted += f.getLinesExecuted();
        }
        this.rootNode = new CovRootTreeElement(Messages.CovManager_Summary, summaryTotal, summaryExecuted, summaryInstrumented);
        IBinaryParser.IBinaryObject binaryObject = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(this.binaryPath));
        for (Folder fldr : this.allFolders) {
            String folderLocation = fldr.getPath();
            CovFolderTreeElement fldrTreeElem = new CovFolderTreeElement(this.rootNode, folderLocation, fldr.getNumLines(), fldr.getLinesExecuted(), fldr.getLinesInstrumented());
            this.rootNode.addChild(fldrTreeElem);
            for (SourceFile src : fldr.getSrcFiles()) {
                CovFileTreeElement srcTreeElem = new CovFileTreeElement(fldrTreeElem, src.getName(), src.getNumLines(), src.getLinesExecuted(), src.getLinesInstrumented());
                fldrTreeElem.addChild(srcTreeElem);
                for (GcnoFunction fnctn : src.getFnctns()) {
                    String name = fnctn.getName();
                    name = STSymbolManager.sharedInstance.demangle(binaryObject, name, this.project);
                    srcTreeElem.addChild(new CovFunctionTreeElement(srcTreeElem, name, fnctn.getSrcFile(), fnctn.getFirstLineNmbr(), fnctn.getCvrge().getLinesExecuted(), fnctn.getCvrge().getLinesInstrumented()));
                }
            }
        }
    }

    private String getWinOSType() {
        if (winOSType.equals("")) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "echo $OSTYPE"});
                String firstLine = null;
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    firstLine = stdout.readLine();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (firstLine != null) {
                    winOSType = firstLine.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return winOSType;
    }

    private String getTransformedPathString(IPath path) {
        String s = path.toOSString();
        if (Platform.getOS().equals("win32")) {
            s = this.getWinOSType().equals("cygwin") ? s.replaceAll("^\\\\cygdrive\\\\([a-zA-Z])", "$1:") : s.replaceAll("^\\\\([a-zA-Z])", "$1:");
        }
        return s;
    }

    private DataInput openTraceFileStream(String filePath, String extension, Map<File, File> sourcePath) throws FileNotFoundException {
        Path p = new Path(filePath);
        filePath = this.getTransformedPathString((IPath)p);
        File f = new File(filePath).getAbsoluteFile();
        String filename = f.getName();
        if (f.isFile() && f.canRead()) {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream inputStream = new BufferedInputStream(fis);
            return new DataInputStream(inputStream);
        }
        String postfix = "";
        File dir = null;
        do {
            postfix = postfix.isEmpty() ? f.getName() : String.valueOf(f.getName()) + File.separator + postfix;
        } while ((f = f.getParentFile()) != null && (dir = sourcePath.get(f)) == null);
        if (dir != null && (f = new File(dir, postfix)).isFile() && f.canRead()) {
            return this.openTraceFileStream(f.getAbsolutePath(), extension, sourcePath);
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fg = new FileDialog(shell, 4096);
        fg.setFilterExtensions(new String[]{"*" + extension, "*.*", "*"});
        fg.setFileName(filename);
        fg.setText(NLS.bind((String)Messages.CovManager_No_FilePath_Error, (Object[])new Object[]{filePath, filename}));
        String s = fg.open();
        if (s == null) {
            return null;
        }
        f = new File(s).getAbsoluteFile();
        this.addSourceLookup(sourcePath, f, new File(filePath).getAbsoluteFile());
        if (f.isFile() && f.canRead()) {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream inputStream = new BufferedInputStream(fis);
            return new DataInputStream(inputStream);
        }
        return null;
    }

    public ArrayList<SourceFile> getAllSrcs() {
        return this.allSrcs;
    }

    public ArrayList<GcnoFunction> getAllFnctns() {
        return this.allFnctns;
    }

    public CovRootTreeElement getRootNode() {
        return this.rootNode;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public SourceFile getSourceFile(String sourcePath) {
        return this.sourceMap.get(sourcePath);
    }

    public long getNbrPgmRuns() {
        return this.nbrPgmRuns;
    }

    public List<String> getGCDALocations() throws InterruptedException {
        IBinaryParser.IBinaryObject binaryObject = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(this.binaryPath));
        String binaryPath = binaryObject.getPath().toOSString();
        STStrings strings = STSymbolManager.sharedInstance.getStrings(binaryObject, this.project);
        LinkedList<String> l = new LinkedList<String>();
        Process p = this.getStringsProcess(strings.getName(), strings.getArgs(), binaryPath);
        if (p == null) {
            Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, Messages.CovManager_Retrieval_Error, (Throwable)new IOException());
            Activator.getDefault().getLog().log((IStatus)status);
            return l;
        }
        ThreadConsumer t = new ThreadConsumer(p, l);
        t.start();
        p.waitFor();
        t.join();
        return l;
    }

    private Process getStringsProcess(String stringsTool, String[] stringsArgs, String binaryPath) {
        String[] runtimeStr = new String[stringsArgs.length + 2];
        System.arraycopy(stringsArgs, 0, runtimeStr, 1, stringsArgs.length);
        runtimeStr[0] = stringsTool;
        runtimeStr[runtimeStr.length - 1] = binaryPath;
        try {
            return Runtime.getRuntime().exec(runtimeStr);
        }
        catch (IOException e) {
            return null;
        }
    }

    public HashMap<String, SourceFile> getSourceMap() {
        return this.sourceMap;
    }

    private void addSourceLookup(Map<File, File> map, File hostPath, File compilerPath) {
        while (hostPath.getName().equals(compilerPath.getName())) {
            hostPath = hostPath.getParentFile();
            compilerPath = compilerPath.getParentFile();
        }
        map.put(compilerPath, hostPath);
    }

    private static final class ThreadConsumer
    extends Thread {
        private final Process p;
        private final List<String> list;

        ThreadConsumer(Process p, List<String> files) {
            this.p = p;
            this.list = files;
        }

        @Override
        public void run() {
            try {
                this.populateGCDAFiles(this.p.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void populateGCDAFiles(InputStream s) throws IOException {
            InputStreamReader isr = new InputStreamReader(s);
            LineNumberReader lnr = new LineNumberReader(isr);
            String line = null;
            while ((line = lnr.readLine()) != null) {
                if (!line.endsWith(".gcda")) continue;
                while (line.length() > 6 && !line.matches("^([A-Za-z]:)?[/\\\\].*")) {
                    line = line.substring(1);
                }
                Path p = new Path(line);
                String filename = p.toString();
                if (this.list.contains(filename)) continue;
                this.list.add(filename);
            }
        }
    }
}

