/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor.assist;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.linuxtools.internal.docker.editor.Activator;
import org.eclipse.linuxtools.internal.docker.editor.assist.CompletionProposal;
import org.eclipse.linuxtools.internal.docker.editor.scanner.InstructionWordRule;
import org.eclipse.linuxtools.internal.docker.editor.util.AssetLoader;

public class CompletionProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static final char[] PROPOSAL_ACTIVATION_CHARS = new char[0];
    private static final char[] INFO_ACTIVATION_CHARS = new char[0];
    private AssetLoader assetLoader = new AssetLoader();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            boolean isNewLine;
            IDocument document = viewer.getDocument();
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            int lineNr = document.getLineOfOffset(offset);
            int lineOffset = document.getLineOffset(lineNr);
            boolean bl = isNewLine = offset == 0 || document.getChar(offset - 1) == '\n';
            if (isNewLine) {
                String[] stringArray = InstructionWordRule.INSTRUCTIONS;
                int n = InstructionWordRule.INSTRUCTIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String instr = stringArray[n2];
                    result.add(new CompletionProposal(instr, lineOffset, 0, this.assetLoader.getInfo(instr)));
                    ++n2;
                }
            }
            boolean isFirstWord = true;
            int i = lineOffset;
            while (i < offset) {
                if (Character.isWhitespace(document.getChar(i))) {
                    isFirstWord = false;
                }
                ++i;
            }
            if (isFirstWord) {
                String prefix = "";
                int i2 = lineOffset;
                while (i2 < offset) {
                    prefix = String.valueOf(prefix) + document.getChar(i2);
                    ++i2;
                }
                String[] stringArray = InstructionWordRule.INSTRUCTIONS;
                int n = InstructionWordRule.INSTRUCTIONS.length;
                int n3 = 0;
                while (n3 < n) {
                    String instr = stringArray[n3];
                    if (instr.toLowerCase().startsWith(prefix.toLowerCase())) {
                        result.add(new CompletionProposal(instr, lineOffset, prefix.length(), this.assetLoader.getInfo(instr)));
                    }
                    ++n3;
                }
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.linuxtools.docker.editor", "Failed to compute completion proposals", (Throwable)e));
            return NO_COMPLETIONS;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return INFO_ACTIVATION_CHARS;
    }

    public String getErrorMessage() {
        return "";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

